/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.networks.signalstrength.tracks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.dot11.networks.BSSID;
import horse.wtf.nzyme.dot11.networks.Channel;
import horse.wtf.nzyme.dot11.networks.SSID;
import horse.wtf.nzyme.dot11.networks.signalstrength.SignalIndexHistogramHistoryDBEntry;
import horse.wtf.nzyme.dot11.networks.signalstrength.tracks.SignalWaterfallHistogram;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdbi.v3.core.statement.Query;
import org.joda.time.DateTime;

public class SignalWaterfallHistogramLoader {
    private static final Logger LOG = LogManager.getLogger(SignalWaterfallHistogramLoader.class);
    public static final String HISTOGRAM_HISTORY_QUERY = "SELECT histogram, created_at FROM sigidx_histogram_history WHERE bssid = ? AND ssid = ? AND channel = ? AND created_at > (current_timestamp at time zone 'UTC' - interval <lookback>) ORDER BY created_at ASC";
    private final NzymeLeader nzyme;

    public SignalWaterfallHistogramLoader(NzymeLeader nzyme) {
        this.nzyme = nzyme;
    }

    public SignalWaterfallHistogram load(BSSID b2, SSID s2, Channel c2, int seconds) {
        List values2 = this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)((Query)((Query)handle.createQuery(HISTOGRAM_HISTORY_QUERY).bind(0, b2.bssid())).bind(1, s2.name())).bind(2, c2.channelNumber())).define("lookback", "'" + seconds + " seconds'")).mapTo(SignalIndexHistogramHistoryDBEntry.class).list());
        ArrayList<List<Long>> z2 = Lists.newArrayList();
        ArrayList<DateTime> y2 = Lists.newArrayList();
        for (SignalIndexHistogramHistoryDBEntry value : values2) {
            try {
                ArrayList<Long> entries = new ArrayList<Long>();
                HashMap<Integer, Long> tempReduced = Maps.newHashMap();
                Map<Integer, Long> histogram = this.nzyme.getObjectMapper().readValue(value.histogram(), new TypeReference<Map<Integer, Long>>(){});
                for (Map.Entry<Integer, Long> x2 : histogram.entrySet()) {
                    tempReduced.put(x2.getKey(), x2.getValue());
                }
                for (int cnt = -100; cnt < 0; ++cnt) {
                    entries.add(tempReduced.getOrDefault(cnt, 0L));
                }
                z2.add(entries);
                y2.add(value.createdAt().withSecondOfMinute(0));
            }
            catch (Exception e2) {
                LOG.error("Could not parse histogram blob to structured data for BSSID [{}].", (Object)b2, (Object)e2);
            }
        }
        ArrayList<Integer> x3 = Lists.newArrayList();
        for (int cnt = -100; cnt < 0; ++cnt) {
            x3.add(cnt);
        }
        return SignalWaterfallHistogram.create(z2, x3, y2);
    }
}

