/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.networks.signalstrength;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.dot11.networks.signalstrength.AutoValue_SignalStrengthTable_SignalStrength;
import horse.wtf.nzyme.util.MetricNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;

public class SignalStrengthTable {
    public static final int RETENTION_MINUTES = 5;
    private final Object mutex = new Object();
    private List<SignalStrength> table = this.newEmptyTable();
    private final String bssid;
    private final String ssid;
    private final int channelNumber;
    private final Timer mutexTimer;

    public SignalStrengthTable(String bssid, String ssid, int channelNumber, MetricRegistry metrics) {
        this.bssid = bssid;
        this.ssid = ssid;
        this.channelNumber = channelNumber;
        this.mutexTimer = metrics.timer(MetricNames.SIGNAL_TABLES_MUTEX_WAIT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordSignalStrength(SignalStrength signalStrength) {
        Timer.Context timer = this.mutexTimer.time();
        Object object = this.mutex;
        synchronized (object) {
            timer.stop();
            this.table.add(signalStrength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retentionClean(int seconds) {
        DateTime cutoff = DateTime.now().minusSeconds(seconds);
        List<SignalStrength> newList = this.newEmptyTable();
        Timer.Context timer = this.mutexTimer.time();
        Object object = this.mutex;
        synchronized (object) {
            timer.stop();
            for (SignalStrength s2 : this.table) {
                if (!s2.timestamp().isAfter(cutoff)) continue;
                newList.add(s2);
            }
            this.table = newList;
        }
    }

    public int getSize() {
        return this.table.size();
    }

    public Map<Integer, AtomicLong> getSignalDistributionHistogram() {
        TreeMap<Integer, AtomicLong> histogram = Maps.newTreeMap();
        for (SignalStrength signalStrength : this.copyOfTable()) {
            if (histogram.containsKey(signalStrength.signalStrength())) {
                ((AtomicLong)histogram.get(signalStrength.signalStrength())).incrementAndGet();
                continue;
            }
            histogram.put(signalStrength.signalStrength(), new AtomicLong(1L));
        }
        return histogram;
    }

    public List<Integer> copyOfAllValues() {
        List<SignalStrength> copy = this.copyOfTable();
        ArrayList<Integer> values2 = Lists.newArrayList();
        for (SignalStrength s2 : copy) {
            values2.add(s2.signalStrength());
        }
        return values2;
    }

    private List<SignalStrength> newEmptyTable() {
        return Lists.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SignalStrength> copyOfTable() {
        Timer.Context timer = this.mutexTimer.time();
        Object object = this.mutex;
        synchronized (object) {
            timer.stop();
            List<SignalStrength> copy = this.newEmptyTable();
            copy.addAll(this.table);
            return copy;
        }
    }

    @AutoValue
    public static abstract class SignalStrength {
        public abstract DateTime timestamp();

        public abstract Integer signalStrength();

        public static SignalStrength create(DateTime timestamp, Integer signalStrength) {
            return SignalStrength.builder().timestamp(timestamp).signalStrength(signalStrength).build();
        }

        public static Builder builder() {
            return new AutoValue_SignalStrengthTable_SignalStrength.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder timestamp(DateTime var1);

            public abstract Builder signalStrength(Integer var1);

            public abstract SignalStrength build();
        }
    }
}

