/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.misc;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.interceptors.misc.PwnagotchiAdvertisement;
import horse.wtf.nzyme.util.Tools;
import java.io.IOException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pcap4j.util.ByteArrays;

public class PwnagotchiAdvertisementExtractor {
    private static final Logger LOG = LogManager.getLogger(PwnagotchiAdvertisementExtractor.class);
    private final ObjectMapper om = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public Optional<PwnagotchiAdvertisement> extract(Dot11BeaconFrame frame) {
        byte[] payload = frame.payload();
        int position = 36;
        StringBuilder advertisement = new StringBuilder();
        try {
            int length;
            do {
                int tag = 0xFF & payload[position];
                length = 0xFF & payload[position + 1];
                if (tag != 222) continue;
                byte[] tagPayload = length == 0 ? new byte[]{} : ByteArrays.getSubArray(payload, position + 2, length);
                advertisement.append(new String(tagPayload));
            } while ((position = position + length + 2) < payload.length);
        }
        catch (Exception e2) {
            LOG.debug("Could not parse 802.11 tagged parameters for pwnagotchi advertisement detection.", (Throwable)e2);
            return Optional.empty();
        }
        String fullAdvertisement = advertisement.toString();
        if (fullAdvertisement.contains("{") && fullAdvertisement.contains("}") && fullAdvertisement.contains("identity")) {
            PwnagotchiAdvertisement parsed = null;
            try {
                parsed = this.om.readValue(fullAdvertisement, PwnagotchiAdvertisement.class);
                if (parsed.identity() == null || parsed.name() == null || parsed.version() == null || parsed.uptime() == null || parsed.pwndThisRun() == null || parsed.pwndTotal() == null) {
                    LOG.warn("Unexpected pwnagotchi advertisement payload. This could mean that the pwnagotchi developers changed the advertisement format and it would be great if you could report this to the nzyme developers, including the following payload: {} {}", (Object)parsed, (Object)Tools.byteArrayToHexPrettyPrint(payload));
                    return Optional.empty();
                }
                return Optional.of(parsed);
            }
            catch (IOException e3) {
                LOG.warn("Failed to parse what looked like a pwnagotchi advertisement payload. Please report this exception to the nzyme team, including the following payload: {} {}", (Object)e3, (Object)Tools.byteArrayToHexPrettyPrint(payload));
                return Optional.empty();
            }
        }
        return Optional.empty();
    }
}

