/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.interceptors;

import com.google.common.collect.ImmutableList;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.CryptoChangeBeaconAlert;
import horse.wtf.nzyme.alerts.CryptoChangeProbeRespAlert;
import horse.wtf.nzyme.alerts.service.AlertsService;
import horse.wtf.nzyme.configuration.Dot11NetworkDefinition;
import horse.wtf.nzyme.dot11.Dot11FrameInterceptor;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import horse.wtf.nzyme.util.Dot11CryptoComparator;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

public class CryptoChangeInterceptorSet {
    private final List<Dot11NetworkDefinition> configuredNetworks;
    private final AlertsService alerts;

    public CryptoChangeInterceptorSet(AlertsService alerts, List<Dot11NetworkDefinition> configuredNetworks) {
        this.alerts = alerts;
        this.configuredNetworks = configuredNetworks;
    }

    public List<Dot11FrameInterceptor> getInterceptors() {
        ImmutableList.Builder interceptors = new ImmutableList.Builder();
        interceptors.add(new Dot11FrameInterceptor<Dot11ProbeResponseFrame>(){

            @Override
            public void intercept(Dot11ProbeResponseFrame frame) {
                if (frame.ssid() == null) {
                    return;
                }
                for (Dot11NetworkDefinition network : CryptoChangeInterceptorSet.this.configuredNetworks) {
                    if (!network.ssid().equals(frame.ssid()) || Dot11CryptoComparator.compareSecurity(frame.taggedParameters().getSecurityStrings(), network.security())) continue;
                    CryptoChangeInterceptorSet.this.alerts.handle(CryptoChangeProbeRespAlert.create(DateTime.now(), frame.ssid(), frame.transmitter(), frame.taggedParameters().getFullSecurityString(), frame.meta().getChannel(), frame.meta().getFrequency(), frame.meta().getAntennaSignal(), 1L));
                }
            }

            @Override
            public byte forSubtype() {
                return 5;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return new ArrayList<Class<? extends Alert>>(){
                    {
                        this.add(CryptoChangeProbeRespAlert.class);
                    }
                };
            }
        });
        interceptors.add(new Dot11FrameInterceptor<Dot11BeaconFrame>(){

            @Override
            public void intercept(Dot11BeaconFrame frame) {
                if (frame.ssid() == null) {
                    return;
                }
                for (Dot11NetworkDefinition network : CryptoChangeInterceptorSet.this.configuredNetworks) {
                    if (!network.ssid().equals(frame.ssid()) || Dot11CryptoComparator.compareSecurity(frame.taggedParameters().getSecurityStrings(), network.security())) continue;
                    CryptoChangeInterceptorSet.this.alerts.handle(CryptoChangeBeaconAlert.create(DateTime.now(), frame.ssid(), frame.transmitter(), frame.taggedParameters().getFullSecurityString(), frame.meta().getChannel(), frame.meta().getFrequency(), frame.meta().getAntennaSignal(), 1L));
                }
            }

            @Override
            public byte forSubtype() {
                return 8;
            }

            @Override
            public List<Class<? extends Alert>> raisesAlerts() {
                return new ArrayList<Class<? extends Alert>>(){
                    {
                        this.add(CryptoChangeBeaconAlert.class);
                    }
                };
            }
        });
        return interceptors.build();
    }
}

