/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.frames;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.frames.AutoValue_Dot11AuthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import horse.wtf.nzyme.dot11.parsers.Dot11AuthenticationFrameParser;

@AutoValue
public abstract class Dot11AuthenticationFrame
implements Dot11Frame {
    public abstract Dot11AuthenticationFrameParser.ALGORITHM_TYPE algorithm();

    public abstract Short statusCode();

    public abstract String statusString();

    public abstract Short transactionSequence();

    public abstract String destination();

    public abstract String transmitter();

    @Override
    public abstract Dot11MetaInformation meta();

    @Override
    public abstract byte[] payload();

    @Override
    public abstract byte[] header();

    @Override
    public abstract byte frameType();

    @JsonIgnore
    public String descriptionString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TYPE:            AUTHENTICATION").append("\n");
        sb.append("Transmitter:     ").append(this.transmitter()).append("\n");
        sb.append("Destination:     ").append(this.destination()).append("\n");
        sb.append("Status String:   ").append(this.statusString()).append("\n");
        sb.append("Status Code:     ").append(this.statusCode()).append("\n");
        sb.append("Transaction Seq: ").append(this.transactionSequence()).append("\n");
        sb.append("Algorithm:       ").append((Object)this.algorithm()).append("\n");
        return sb.toString();
    }

    public static Dot11AuthenticationFrame create(Dot11AuthenticationFrameParser.ALGORITHM_TYPE algorithm, Short statusCode, String statusString, Short transactionSequence, String destination, String transmitter, Dot11MetaInformation meta, byte[] payload, byte[] header) {
        return Dot11AuthenticationFrame.builder().algorithm(algorithm).statusCode(statusCode).statusString(statusString).transactionSequence(transactionSequence).destination(destination).transmitter(transmitter).meta(meta).payload(payload).header(header).frameType((byte)11).build();
    }

    public static Builder builder() {
        return new AutoValue_Dot11AuthenticationFrame.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder algorithm(Dot11AuthenticationFrameParser.ALGORITHM_TYPE var1);

        public abstract Builder statusCode(Short var1);

        public abstract Builder statusString(String var1);

        public abstract Builder transactionSequence(Short var1);

        public abstract Builder destination(String var1);

        public abstract Builder transmitter(String var1);

        public abstract Builder meta(Dot11MetaInformation var1);

        public abstract Builder payload(byte[] var1);

        public abstract Builder header(byte[] var1);

        public abstract Builder frameType(byte var1);

        public abstract Dot11AuthenticationFrame build();
    }
}

