/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.frames;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.frames.AutoValue_Dot11AssociationResponseFrame;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;

@AutoValue
public abstract class Dot11AssociationResponseFrame
implements Dot11Frame {
    public abstract String transmitter();

    public abstract String destination();

    public abstract String response();

    public abstract Short responseCode();

    @Override
    public abstract Dot11MetaInformation meta();

    @Override
    public abstract byte[] payload();

    @Override
    public abstract byte[] header();

    @Override
    public abstract byte frameType();

    @JsonIgnore
    public String descriptionString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TYPE:          ASSOCIATION RESPONSE").append("\n");
        sb.append("Transmitter:   ").append(this.transmitter()).append("\n");
        sb.append("Destination:   ").append(this.destination()).append("\n");
        sb.append("Response:      ").append(this.response()).append("\n");
        sb.append("Response Code: ").append(this.responseCode()).append("\n");
        return sb.toString();
    }

    public static Dot11AssociationResponseFrame create(String transmitter, String destination, String response, Short responseCode, Dot11MetaInformation meta, byte[] payload, byte[] header) {
        return Dot11AssociationResponseFrame.builder().transmitter(transmitter).destination(destination).response(response).responseCode(responseCode).meta(meta).payload(payload).header(header).frameType((byte)1).build();
    }

    public static Builder builder() {
        return new AutoValue_Dot11AssociationResponseFrame.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder transmitter(String var1);

        public abstract Builder destination(String var1);

        public abstract Builder response(String var1);

        public abstract Builder responseCode(Short var1);

        public abstract Builder meta(Dot11MetaInformation var1);

        public abstract Builder payload(byte[] var1);

        public abstract Builder header(byte[] var1);

        public abstract Builder frameType(byte var1);

        public abstract Dot11AssociationResponseFrame build();
    }
}

