/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.deception.traps;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import horse.wtf.nzyme.dot11.Dot11FrameInterceptor;
import horse.wtf.nzyme.dot11.deception.bluffs.Beacon;
import horse.wtf.nzyme.dot11.deception.traps.Trap;
import horse.wtf.nzyme.dot11.interceptors.BeaconTrapResponseInterceptorSet;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BeaconTrap
extends Trap {
    private static final Logger LOG = LogManager.getLogger(BeaconTrap.class);
    private final String interfaceName;
    private final List<String> ssids;
    private final String transmitter;
    private final int delayMilliseconds;
    private final String ourFingerprint;
    private final NzymeLeader nzyme;
    private final int framesPerExecution;

    public BeaconTrap(NzymeLeader nzyme, String interfaceName, List<String> ssids, String transmitter, int delayMilliseconds, String ourFingerprint) {
        this.nzyme = nzyme;
        this.interfaceName = interfaceName;
        this.ssids = ssids;
        this.transmitter = transmitter;
        this.delayMilliseconds = delayMilliseconds;
        this.ourFingerprint = ourFingerprint;
        this.framesPerExecution = ssids.size();
        nzyme.registerIgnoredFingerprint(ourFingerprint);
    }

    @Override
    public void checkConfiguration() throws InvalidConfigurationException {
        if (Strings.isNullOrEmpty(this.interfaceName)) {
            throw new InvalidConfigurationException("Interface name is empty.");
        }
        if (this.ssids == null || this.ssids.isEmpty()) {
            throw new InvalidConfigurationException("SSIDs is null or empty.");
        }
        if (Strings.isNullOrEmpty(this.transmitter)) {
            throw new InvalidConfigurationException("Transmitter is null or emtpy.");
        }
        if (this.delayMilliseconds <= 0) {
            throw new InvalidConfigurationException("Delay milliseconds must be configured to a value larger than 0.");
        }
        if (Strings.isNullOrEmpty(this.ourFingerprint)) {
            throw new InvalidConfigurationException("Fingerprint is empty.");
        }
    }

    @Override
    protected boolean doRun() {
        Iterator<String> iterator2 = this.ssids.iterator();
        if (iterator2.hasNext()) {
            String ssid = iterator2.next();
            LOG.debug("Setting BeaconTrap for SSID [{}].", (Object)ssid);
            try {
                new Beacon(this.nzyme.getConfiguration(), this.interfaceName, ssid, this.transmitter).execute();
                return true;
            }
            catch (Exception e2) {
                LOG.error("Could not set Beacon for SSID [{}].", (Object)ssid, (Object)e2);
                return false;
            }
        }
        return false;
    }

    @Override
    public int getDelayMilliseconds() {
        return this.delayMilliseconds;
    }

    @Override
    public int framesPerExecution() {
        return this.framesPerExecution;
    }

    @Override
    public Trap.Type getType() {
        return Trap.Type.BEACON_1;
    }

    @Override
    public String getDescription() {
        return "Setting trap for SSIDs [" + Joiner.on(", ").join(this.ssids) + "] every " + this.getDelayMilliseconds() + "ms.";
    }

    @Override
    public List<Dot11FrameInterceptor> requestedInterceptors() {
        return new BeaconTrapResponseInterceptorSet(this.nzyme.getAlertsService(), this.ssids, this.ourFingerprint).getInterceptors();
    }
}

