/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.deception.bluffs;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import horse.wtf.nzyme.configuration.leader.LeaderConfiguration;
import horse.wtf.nzyme.util.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Bluff {
    private static final Logger LOG = LogManager.getLogger(Bluff.class);
    private final LeaderConfiguration configuration;
    @Nullable
    private String invokedCommand;
    private final List<String> stderr;

    protected abstract String scriptCategory();

    protected abstract String scriptName();

    protected abstract Map<String, String> parameters();

    public Bluff(LeaderConfiguration configuration) {
        this.configuration = configuration;
        this.stderr = Lists.newArrayList();
    }

    public void execute() throws BluffExecutionException, InsecureParametersException {
        try {
            String line;
            File script = this.ensureScript();
            StringBuilder exec = new StringBuilder().append(this.configuration.pythonExecutable()).append(" ").append(script.getCanonicalPath()).append(" ");
            for (Map.Entry<String, String> parameter : this.parameters().entrySet()) {
                exec.append(parameter.getKey()).append(" ").append(parameter.getValue()).append(" ");
            }
            this.invokedCommand = exec.toString().trim();
            try {
                this.validateParameters();
            }
            catch (InsecureParametersException e2) {
                LOG.warn("Insecure parameters passed to bluff [{}]. Refusing to execute.", (Object)this.getClass().getCanonicalName());
                throw e2;
            }
            Process p2 = Runtime.getRuntime().exec(this.invokedCommand);
            BufferedReader err = new BufferedReader(new InputStreamReader(p2.getErrorStream()));
            while ((line = err.readLine()) != null) {
                this.stderr.add(line);
            }
            p2.waitFor();
            err.close();
            if (!this.stderr.isEmpty()) {
                this.debug();
                throw new BluffExecutionException("STDERR is not empty.");
            }
        }
        catch (InterruptedException e3) {
            LOG.info("Bluff [{}] interrupted.", (Object)this.getClass().getCanonicalName(), (Object)e3);
        }
        catch (IOException e4) {
            throw new BluffExecutionException((Throwable)e4);
        }
    }

    public void debug() {
        LOG.info("Bluff [{}]: Invoked command {{}}.", (Object)this.getClass().getCanonicalName(), (Object)this.getInvokedCommand());
        if (this.stderr.isEmpty()) {
            LOG.info("Bluff [{}]: No lines written to STDERR.", (Object)this.getClass().getCanonicalName());
        } else {
            LOG.info("Bluff [{}]: {} lines written to STDERR:", (Object)this.getClass().getCanonicalName(), (Object)this.stderr.size());
            for (String line : this.stderr) {
                LOG.info("\t\tSTDERR: {}", (Object)line);
            }
        }
    }

    private void validateParameters() throws InsecureParametersException {
        if (!(Tools.isSafeParameter(this.configuration.pythonScriptDirectory()) && Tools.isSafeParameter(this.configuration.pythonScriptPrefix()) && Tools.isSafeParameter(this.configuration.pythonExecutable()) && Tools.isSafeParameter(this.getClass().getSimpleName()) && Tools.isSafeParameter(this.scriptCategory()) && Tools.isSafeParameter(this.scriptName()))) {
            throw new InsecureParametersException();
        }
        for (Map.Entry<String, String> x2 : this.parameters().entrySet()) {
            if (Tools.isSafeParameter(x2.getKey()) && Tools.isSafeParameter(x2.getValue())) continue;
            throw new InsecureParametersException();
        }
    }

    private File ensureScript() throws IOException {
        URL url = Resources.getResource("bluffs/" + this.scriptCategory() + "/" + this.scriptName());
        String text = Resources.toString(url, Charsets.UTF_8);
        File target = new File("/" + this.configuration.pythonScriptDirectory() + "/" + this.configuration.pythonScriptPrefix() + this.getClass().getSimpleName());
        Files.asByteSink(target, new FileWriteMode[0]).write(text.getBytes());
        return target;
    }

    @Nullable
    public String getInvokedCommand() {
        return this.invokedCommand;
    }

    public class BluffExecutionException
    extends Exception {
        public BluffExecutionException(String s2) {
            super(s2);
        }

        public BluffExecutionException(Throwable t2) {
            super(t2);
        }
    }

    public class InsecureParametersException
    extends Exception {
    }
}

