/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.deauth;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.DeauthFloodAlert;
import horse.wtf.nzyme.dot11.frames.Dot11DeauthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11DisassociationFrame;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdbi.v3.core.statement.Update;
import org.joda.time.DateTime;

public class DeauthenticationMonitor {
    private static final Logger LOG = LogManager.getLogger(DeauthenticationMonitor.class);
    private final NzymeLeader nzyme;
    private final AtomicInteger counter;
    private final ScheduledExecutorService service;

    public DeauthenticationMonitor(NzymeLeader nzyme) {
        this(nzyme, 60);
    }

    public DeauthenticationMonitor(NzymeLeader nzyme, int syncIntervalSeconds) {
        this.nzyme = nzyme;
        this.counter = new AtomicInteger(0);
        this.service = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("deauthmonitor").build());
        this.service.scheduleAtFixedRate(this::run, syncIntervalSeconds, syncIntervalSeconds, TimeUnit.SECONDS);
    }

    protected void run() {
        try {
            int count = this.counter.get();
            this.counter.set(0);
            if (this.nzyme.getConfiguration().deauth() != null && this.nzyme.getConfiguration().dot11Alerts().contains((Object)Alert.TYPE_WIDE.DEAUTH_FLOOD)) {
                int threshold = this.nzyme.getConfiguration().deauth().globalThreshold();
                if (count > threshold) {
                    this.nzyme.getAlertsService().handle(DeauthFloodAlert.create(DateTime.now(), count, threshold));
                }
            } else {
                LOG.debug("DEAUTH_FLOOD alert disabled or not fully configured. Not checking.");
            }
            this.nzyme.getDatabase().useHandle(handle -> ((Update)((Update)handle.createUpdate("INSERT INTO deauth_monitor(total_frame_count, created_at) VALUES(:frame_count, :created_at)").bind("frame_count", count)).bind("created_at", (Object)DateTime.now().withMillisOfSecond(0))).execute());
        }
        catch (Exception e2) {
            LOG.error("Could not run deauthentication monitor.", (Throwable)e2);
        }
    }

    public void stop() {
        this.service.shutdown();
    }

    public long currentCount() {
        return this.counter.get();
    }

    public void record(Dot11DeauthenticationFrame frame) {
        this.counter.incrementAndGet();
    }

    public void record(Dot11DisassociationFrame frame) {
        this.counter.incrementAndGet();
    }
}

