/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.clients;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.dot11.clients.Client;
import horse.wtf.nzyme.dot11.frames.Dot11AssociationRequestFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeRequestFrame;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class Clients {
    private static final Logger LOG = LogManager.getLogger(Clients.class);
    private final Map<String, Client> clients;
    private final NzymeLeader nzyme;

    public Clients(NzymeLeader nzyme) {
        this.nzyme = nzyme;
        this.clients = Maps.newHashMap();
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("clients-cleaner").build()).scheduleAtFixedRate(() -> this.retentionClean(300), 1L, 1L, TimeUnit.MINUTES);
    }

    public void registerProbeRequestFrame(Dot11ProbeRequestFrame frame) {
        this.register(frame.requester());
    }

    public void registerAssociationRequestFrame(Dot11AssociationRequestFrame frame) {
        this.register(frame.transmitter());
    }

    private synchronized void register(String mac) {
        if (this.clients.containsKey(mac)) {
            this.clients.get(mac).updateLastSeen();
        } else {
            String oui = this.nzyme.getOUIManager().lookupBSSID(mac);
            if (oui == null) {
                oui = "unknown";
            }
            Client client = Client.create(oui, mac);
            this.clients.put(mac, client);
        }
    }

    public Map<String, Client> getClients() {
        return new ImmutableMap.Builder<String, Client>().putAll(this.clients).build();
    }

    public void retentionClean(int seconds) {
        try {
            for (Map.Entry<String, Client> entry : Lists.newArrayList(this.clients.entrySet())) {
                Client client = entry.getValue();
                if (!client.lastSeen.isBefore(DateTime.now().minusSeconds(seconds))) continue;
                LOG.debug("Retention cleaning expired client [{}] from internal clients list.", (Object)client);
                this.clients.remove(entry.getKey());
            }
        }
        catch (Exception e2) {
            LOG.error("Error when trying to clean expired clients.", (Throwable)e2);
        }
    }
}

