/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11.anonymization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.dot11.anonymization.Anonfile;
import horse.wtf.nzyme.dot11.anonymization.RandomSSID;
import java.io.File;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Anonymizer {
    private static final Logger LOG = LogManager.getLogger(Anonymizer.class);
    private static final String ANONFILE_NAME = "anonfile";
    private final boolean isEnabled;
    private final String nzymeDataDirectoryPath;
    private final ObjectMapper om;
    private Map<String, String> ssids;
    private Map<String, String> bssids;

    public Anonymizer(boolean isEnabled, String nzymeDataDirectoryPath) {
        this.isEnabled = isEnabled;
        this.nzymeDataDirectoryPath = nzymeDataDirectoryPath;
        this.om = new ObjectMapper();
        this.ssids = Maps.newHashMap();
        this.bssids = Maps.newHashMap();
        if (isEnabled) {
            this.loadFromFile();
            Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("anonfile-writer-%d").build()).scheduleWithFixedDelay(this::writeToFile, 1L, 1L, TimeUnit.MINUTES);
        }
    }

    private void loadFromFile() {
        if (!this.isEnabled) {
            return;
        }
        File file = new File(this.nzymeDataDirectoryPath + "/anonfile");
        if (!file.exists()) {
            LOG.error("Anonfile not found.");
            return;
        }
        try {
            String content = new String(Files.toByteArray(file), Charsets.UTF_8);
            Anonfile parsed = this.om.readValue(content, Anonfile.class);
            LOG.info("Replaying anonfile.");
            this.ssids = parsed.ssids();
            this.bssids = parsed.bssids();
        }
        catch (Exception e2) {
            LOG.error("Anonfile exists but failed to parse.", (Throwable)e2);
            return;
        }
    }

    private void writeToFile() {
        try {
            Files.write(this.om.writeValueAsBytes(Anonfile.create(this.ssids, this.bssids)), new File(this.nzymeDataDirectoryPath + "/anonfile"));
        }
        catch (Exception e2) {
            LOG.error("Could not write anonfile.", (Throwable)e2);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public String anonymizeSSID(String ssid) {
        if (!this.isEnabled || Strings.isNullOrEmpty(ssid)) {
            return ssid;
        }
        String anonymized = this.ssids.get(ssid);
        if (anonymized != null) {
            return anonymized;
        }
        Object random = RandomSSID.POPULATION.get(new Random().nextInt(RandomSSID.POPULATION.size()));
        if (this.ssids.containsKey(random)) {
            random = "ssid-" + new Random().nextInt(999999);
        }
        this.ssids.put(ssid, (String)random);
        return random;
    }

    public String anonymizeBSSID(String bssid) {
        if (!this.isEnabled || Strings.isNullOrEmpty(bssid)) {
            return bssid;
        }
        String anonymized = this.bssids.get(bssid = bssid.toLowerCase());
        if (anonymized != null) {
            return anonymized;
        }
        Random random = new Random();
        String generated = String.format(bssid.substring(0, 8) + ":%02X:%02X:%02X", random.nextInt(255), random.nextInt(255), random.nextInt(255)).toLowerCase();
        this.bssids.put(bssid, generated);
        return generated;
    }
}

