/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import horse.wtf.nzyme.dot11.Dot11SecurityConfiguration;
import horse.wtf.nzyme.dot11.MalformedFrameException;
import horse.wtf.nzyme.util.Tools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pcap4j.util.ByteArrays;

public class Dot11TaggedParameters {
    private static final Logger LOG = LogManager.getLogger(Dot11TaggedParameters.class);
    public static final int BEACON_TAGGED_PARAMS_POSITION = 36;
    public static final int PROBERESP_TAGGED_PARAMS_POSITION = 36;
    public static final int ASSOCREQ_TAGGED_PARAMS_POSITION = 28;
    public static final int WPA1_UNICAST_CYPHER_SUITE_COUNT_POSITION = 10;
    public static final int WPA2_PAIRWISE_CYPHER_SUITE_COUNT_POSITION = 6;
    public static ImmutableList<Integer> FINGERPRINT_IDS = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add((Object)1)).add((Object)7)).add((Object)45)).add((Object)48)).add((Object)50)).add((Object)127)).build();
    private static final int ID_SSID = 0;
    private static final int ID_RSN = 48;
    private static final String ID_VENDOR_SPECIFIC_WPS = "00:50:F2-4";
    private static final String ID_VENDOR_SPECIFIC_WPA = "00:50:F2-1";
    private final TreeMap<Integer, byte[]> params;
    private final TreeMap<String, byte[]> vendorSpecificParams;
    private final Timer parserTimer;
    private final Timer fingerprintTimer;

    /*
     * Exception decompiling
     */
    public Dot11TaggedParameters(MetricRegistry metrics, int startPosition, byte[] payload) throws MalformedFrameException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 5[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dot11SecurityConfiguration> getSecurityConfiguration() {
        List<Dot11SecurityConfiguration.KEY_MGMT_MODE> keyMgmtModes;
        List<Dot11SecurityConfiguration.ENCRYPTION_MODE> encryptionModes;
        ImmutableList.Builder configurations = new ImmutableList.Builder();
        int found = 0;
        if (this.vendorSpecificParams.containsKey(ID_VENDOR_SPECIFIC_WPA)) {
            try {
                byte[] wpa1 = this.vendorSpecificParams.get(ID_VENDOR_SPECIFIC_WPA);
                LOG.trace("WPA1 payload: {}", () -> Tools.byteArrayToHexPrettyPrint(wpa1));
                encryptionModes = this.parseEncryptionModes(10, wpa1);
                keyMgmtModes = this.parseKeyMgmtModes(10 + encryptionModes.size() * 4 + 2, wpa1);
                configurations.add(Dot11SecurityConfiguration.create(Dot11SecurityConfiguration.MODE.WPA1, keyMgmtModes, encryptionModes));
            }
            catch (Exception e2) {
                LOG.error("Could not parse WPA1 information from frame.", (Throwable)e2);
            }
            finally {
                ++found;
            }
        }
        if (this.params.containsKey(48)) {
            try {
                byte[] rsn = this.params.get(48);
                LOG.trace("WPA2 payload: {}", () -> Tools.byteArrayToHexPrettyPrint(rsn));
                encryptionModes = this.parseEncryptionModes(6, rsn);
                keyMgmtModes = this.parseKeyMgmtModes(6 + encryptionModes.size() * 4 + 2, rsn);
                Dot11SecurityConfiguration.MODE mode = keyMgmtModes.contains((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.SAE) ? Dot11SecurityConfiguration.MODE.WPA3 : Dot11SecurityConfiguration.MODE.WPA2;
                configurations.add(Dot11SecurityConfiguration.create(mode, keyMgmtModes, encryptionModes));
            }
            catch (Exception e3) {
                LOG.error("Could not parse WPA2 information from frame.", (Throwable)e3);
            }
            finally {
                ++found;
            }
        }
        if (found == 0) {
            configurations.add(Dot11SecurityConfiguration.create(Dot11SecurityConfiguration.MODE.NONE, Collections.emptyList(), Collections.emptyList()));
        }
        return configurations.build();
    }

    public boolean isWPA1() {
        return this.vendorSpecificParams.containsKey(ID_VENDOR_SPECIFIC_WPA);
    }

    public boolean isWPA2() {
        return !this.isWPA3() && this.params.containsKey(48);
    }

    public boolean isWPA3() {
        if (!this.params.containsKey(48)) {
            return false;
        }
        for (Dot11SecurityConfiguration sec : this.getSecurityConfiguration()) {
            if (!sec.keyManagementModes().contains((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.SAE)) continue;
            return true;
        }
        return false;
    }

    public boolean isWPS() {
        return this.vendorSpecificParams.containsKey(ID_VENDOR_SPECIFIC_WPS);
    }

    public String getFullSecurityString() {
        return Joiner.on(", ").join(this.getSecurityStrings());
    }

    public List<String> getSecurityStrings() {
        ImmutableList.Builder x2 = new ImmutableList.Builder();
        this.getSecurityConfiguration().forEach(s2 -> x2.add(s2.asString()));
        return x2.build();
    }

    public String getSSID() throws MalformedFrameException, NoSuchTaggedElementException {
        if (!this.params.containsKey(0)) {
            throw new NoSuchTaggedElementException();
        }
        byte[] bytes = this.params.get(0);
        if (bytes.length == 0) {
            return null;
        }
        if (!Tools.isValidUTF8(bytes)) {
            throw new MalformedFrameException();
        }
        return new String(bytes, Charsets.UTF_8);
    }

    public String fingerprint() {
        Timer.Context time = this.fingerprintTimer.time();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        this.params.forEach((k2, v2) -> {
            try {
                if (FINGERPRINT_IDS.contains(k2)) {
                    bytes.write((byte[])v2);
                }
            }
            catch (IOException e2) {
                LOG.error("Could not assemble bytes for fingerprinting.", (Throwable)e2);
            }
        });
        this.vendorSpecificParams.forEach((k2, v2) -> {
            try {
                bytes.write(k2.getBytes());
            }
            catch (IOException e2) {
                LOG.error("Could not assemble bytes for fingerprinting.", (Throwable)e2);
            }
        });
        String fingerprint = Hashing.sha256().hashBytes(bytes.toByteArray()).toString();
        time.stop();
        return fingerprint;
    }

    private List<Byte> parseSuites(int suiteCount, byte[] payload, int offset) {
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (int i2 = 0; i2 < suiteCount; ++i2) {
            byte[] suite = ByteArrays.getSubArray(payload, offset + 2, 4);
            result.add((Object)suite[3]);
            offset += 4;
        }
        return result.build();
    }

    private List<Dot11SecurityConfiguration.ENCRYPTION_MODE> parseEncryptionModes(int startPosition, byte[] payload) {
        ImmutableList.Builder encryptionModes = new ImmutableList.Builder();
        byte cypherSuitesCount = payload[startPosition];
        this.parseSuites(cypherSuitesCount, payload, startPosition).forEach(suite -> {
            switch (suite) {
                case 1: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.WEP);
                    break;
                }
                case 2: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.TKIP);
                    break;
                }
                case 4: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.CCMP);
                    break;
                }
                case 5: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.WEP104);
                    break;
                }
                case 6: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.BIPCMAC128);
                    break;
                }
                case 8: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.GCMP128);
                    break;
                }
                case 9: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.GCMP256);
                    break;
                }
                case 10: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.CCMP256);
                    break;
                }
                case 11: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.BIPGMAC128);
                    break;
                }
                case 12: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.BIPGMAC256);
                    break;
                }
                case 13: {
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.BIPCMAC256);
                    break;
                }
                default: {
                    LOG.warn("Unknown encryption mode [{}].", suite);
                    encryptionModes.add((Object)Dot11SecurityConfiguration.ENCRYPTION_MODE.UNKNOWN);
                }
            }
        });
        return encryptionModes.build();
    }

    private List<Dot11SecurityConfiguration.KEY_MGMT_MODE> parseKeyMgmtModes(int startPosition, byte[] payload) {
        ImmutableList.Builder keyMgmtModes = new ImmutableList.Builder();
        byte keyMgmtModesCount = payload[startPosition];
        this.parseSuites(keyMgmtModesCount, payload, startPosition).forEach(suite -> {
            switch (suite) {
                case 1: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.EAM);
                    break;
                }
                case 2: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.PSK);
                    break;
                }
                case 3: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.FTEAM);
                    break;
                }
                case 4: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.FTPSK);
                    break;
                }
                case 5: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.EAMSHA256);
                    break;
                }
                case 6: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.PSKSHA256);
                    break;
                }
                case 7: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.TDLS);
                    break;
                }
                case 8: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.SAE);
                    break;
                }
                case 9: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.FTSAESHA256);
                    break;
                }
                case 10: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.APPEERKEY);
                    break;
                }
                case 11: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.EAMEAPSHA256);
                    break;
                }
                case 12: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.EAMEAPSHA384);
                    break;
                }
                case 13: {
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.FTEAMSHA384);
                    break;
                }
                default: {
                    LOG.warn("Unknown key management mode [{}].", suite);
                    keyMgmtModes.add((Object)Dot11SecurityConfiguration.KEY_MGMT_MODE.UNKNOWN);
                }
            }
        });
        return keyMgmtModes.build();
    }

    public class NoSuchTaggedElementException
    extends Exception {
    }
}

