/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.dot11;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.dot11.AutoValue_Dot11SecurityConfiguration;
import java.util.List;

@AutoValue
public abstract class Dot11SecurityConfiguration {
    @JsonProperty(value="wpa_mode")
    public abstract MODE wpaMode();

    @JsonProperty(value="key_mgmt_modes")
    public abstract List<KEY_MGMT_MODE> keyManagementModes();

    @JsonProperty(value="encryption_modes")
    public abstract List<ENCRYPTION_MODE> encryptionModes();

    @JsonProperty(value="as_string")
    public String asString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.wpaMode());
        for (KEY_MGMT_MODE managementMode : this.keyManagementModes()) {
            sb.append("-").append((Object)managementMode);
        }
        for (ENCRYPTION_MODE encryptionMode : this.encryptionModes()) {
            sb.append("-").append((Object)encryptionMode);
        }
        return sb.toString();
    }

    public static Dot11SecurityConfiguration create(MODE wpaMode, List<KEY_MGMT_MODE> keyManagementModes, List<ENCRYPTION_MODE> encryptionModes) {
        return Dot11SecurityConfiguration.builder().wpaMode(wpaMode).keyManagementModes(keyManagementModes).encryptionModes(encryptionModes).build();
    }

    public static Builder builder() {
        return new AutoValue_Dot11SecurityConfiguration.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder wpaMode(MODE var1);

        public abstract Builder keyManagementModes(List<KEY_MGMT_MODE> var1);

        public abstract Builder encryptionModes(List<ENCRYPTION_MODE> var1);

        public abstract Dot11SecurityConfiguration build();
    }

    public static enum ENCRYPTION_MODE {
        WEP,
        TKIP,
        CCMP,
        WEP104,
        BIPCMAC128,
        GCMP128,
        GCMP256,
        CCMP256,
        BIPGMAC128,
        BIPGMAC256,
        BIPCMAC256,
        UNKNOWN;

    }

    public static enum KEY_MGMT_MODE {
        EAM,
        PSK,
        FTEAM,
        FTPSK,
        EAMSHA256,
        PSKSHA256,
        TDLS,
        SAE,
        FTSAESHA256,
        APPEERKEY,
        EAMEAPSHA256,
        EAMEAPSHA384,
        FTEAMSHA384,
        UNKNOWN;

    }

    public static enum MODE {
        NONE,
        WPA1,
        WPA2,
        WPA3;

    }
}

