/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.configuration.leader;

import com.beust.jcommander.internal.Lists;
import com.google.common.base.Enums;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import horse.wtf.nzyme.Role;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.service.callbacks.AlertCallback;
import horse.wtf.nzyme.alerts.service.callbacks.EmailCallback;
import horse.wtf.nzyme.alerts.service.callbacks.FileCallback;
import horse.wtf.nzyme.bandits.trackers.devices.TrackerDevice;
import horse.wtf.nzyme.configuration.BaseDot11ConfigurationLoader;
import horse.wtf.nzyme.configuration.ConfigurationValidator;
import horse.wtf.nzyme.configuration.DeauthenticationMonitorConfiguration;
import horse.wtf.nzyme.configuration.Dot11MonitorDefinition;
import horse.wtf.nzyme.configuration.Dot11TrapConfiguration;
import horse.wtf.nzyme.configuration.Dot11TrapDeviceDefinition;
import horse.wtf.nzyme.configuration.ForwarderDefinition;
import horse.wtf.nzyme.configuration.IncompleteConfigurationException;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import horse.wtf.nzyme.configuration.ReportingConfiguration;
import horse.wtf.nzyme.configuration.UplinkDefinition;
import horse.wtf.nzyme.configuration.UplinkDeviceConfiguration;
import horse.wtf.nzyme.configuration.leader.LeaderConfiguration;
import horse.wtf.nzyme.dot11.deception.traps.Trap;
import horse.wtf.nzyme.util.Tools;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.simplejavamail.api.email.Recipient;
import org.simplejavamail.api.mailer.config.TransportStrategy;

public class LeaderConfigurationLoader {
    private static final Logger LOG = LogManager.getLogger(LeaderConfigurationLoader.class);
    private final Config root;
    private final Config general;
    private final Config interfaces;
    private final Config python;
    private final Config alerting;
    private final BaseDot11ConfigurationLoader baseDot11ConfigurationLoader;

    public LeaderConfigurationLoader(File configFile, boolean skipValidation) throws InvalidConfigurationException, IncompleteConfigurationException, FileNotFoundException {
        if (!Files.isReadable(configFile.toPath())) {
            throw new FileNotFoundException("File at [" + configFile.getPath() + "] does not exist or is not readable. Check path and permissions.");
        }
        this.root = ConfigFactory.parseFile(configFile).resolve();
        this.baseDot11ConfigurationLoader = new BaseDot11ConfigurationLoader(this.root);
        try {
            this.general = this.root.getConfig("general");
            this.python = this.general.getConfig("python");
            this.alerting = this.general.getConfig("alerting");
            this.interfaces = this.root.getConfig("interfaces");
        }
        catch (ConfigException e2) {
            throw new IncompleteConfigurationException("Incomplete configuration.", e2);
        }
        if (!skipValidation) {
            this.validate();
        }
    }

    public LeaderConfiguration get() {
        return LeaderConfiguration.create(this.parseVersionchecksEnabled(), this.parseFetchOUIsEnabled(), this.parseRole(), this.parseAdminPasswordHash(), this.parseDatabasePath(), this.parsePythonExecutable(), this.parsePythonScriptDirectory(), this.parsePythonScriptPrefix(), this.parseRestListenUri(), this.parseHttpExternalUri(), this.parseUseTls(), this.parseTlsCertificatePath(), this.parseTlsKeyPath(), this.parseRemoteInputAddress(), this.parseUplinks(), this.baseDot11ConfigurationLoader.parseDot11Monitors(), this.baseDot11ConfigurationLoader.parseDot11Networks(), this.parseDot11TrapDeviceDefinitions(), this.parseDot11Alerts(), this.parseAlertingTrainingPeriodSeconds(), this.parseAlertCallbacks(), this.parseForwarders(), this.parseGroundstationDevice(), this.parseReporting(), this.parseDeauth());
    }

    private ReportingConfiguration parseReporting() {
        if (this.root.hasPath("reporting")) {
            ReportingConfiguration.Email email;
            Config c2 = this.root.getConfig("reporting");
            if (c2.hasPath("email")) {
                Recipient from;
                Config e2 = c2.getConfig("email");
                try {
                    from = Tools.parseEmailAddress(e2.getString("from"));
                }
                catch (InvalidConfigurationException ex2) {
                    throw new RuntimeException("Invalid email address format.", ex2);
                }
                email = ReportingConfiguration.Email.create(TransportStrategy.valueOf(e2.getString("transport_strategy")), e2.getString("host"), e2.getInt("port"), e2.getString("username"), e2.getString("password"), from, e2.getString("subject_prefix"));
            } else {
                email = null;
            }
            return ReportingConfiguration.create(email);
        }
        return null;
    }

    private DeauthenticationMonitorConfiguration parseDeauth() {
        if (this.root.hasPath("deauth_monitor")) {
            return DeauthenticationMonitorConfiguration.create(this.root.getConfig("deauth_monitor").getInt("global_threshold"));
        }
        return null;
    }

    private InetSocketAddress parseRemoteInputAddress() {
        if (this.root.hasPath("remote_input")) {
            Config remoteInput = this.root.getConfig("remote_input");
            String host = remoteInput.getString("host");
            int port = remoteInput.getInt("port");
            return new InetSocketAddress(host, port);
        }
        return null;
    }

    private ImmutableList<UplinkDefinition> parseUplinks() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        if (this.root.hasPath("uplinks")) {
            for (Config config : this.root.getConfigList("uplinks")) {
                result.add(UplinkDefinition.create(config.getString("type"), config.getConfig("configuration")));
            }
        }
        if (this.root.hasPath("graylog_uplinks")) {
            LOG.warn("!!! DEPRECATION WANRING !!! The \"graylog_uplinks\" configuration has moved to a generic \"uplinks\" configuration. Please consult the configuration file reference on www.nzyme.org.");
            try {
                List<String> graylogAddresses = this.root.getStringList("graylog_uplinks");
                if (graylogAddresses == null) {
                    return null;
                }
                for (String address : graylogAddresses) {
                    String[] parts = address.split(":");
                    Config config = ConfigFactory.empty().withValue("host", ConfigValueFactory.fromAnyRef(parts[0])).withValue("port", ConfigValueFactory.fromAnyRef(Integer.parseInt(parts[1])));
                    result.add(UplinkDefinition.create("graylog", config));
                }
            }
            catch (ConfigException e2) {
                LOG.debug(e2);
                return null;
            }
        }
        return result.build();
    }

    private Role parseRole() {
        return this.general.getEnum(Role.class, "role");
    }

    private String parseAdminPasswordHash() {
        return this.general.getString("admin_password_hash");
    }

    private String parseDatabasePath() {
        return this.general.getString("database_path");
    }

    private String parsePythonExecutable() {
        return this.python.getString("path");
    }

    private String parsePythonScriptDirectory() {
        return this.python.getString("script_directory");
    }

    private String parsePythonScriptPrefix() {
        return this.python.getString("script_prefix");
    }

    private boolean parseVersionchecksEnabled() {
        return this.general.getBoolean("versionchecks");
    }

    private boolean parseFetchOUIsEnabled() {
        return this.general.getBoolean("fetch_ouis");
    }

    private boolean parseUseTls() {
        return this.interfaces.getBoolean("use_tls");
    }

    @Nullable
    private Path parseTlsCertificatePath() {
        if (this.interfaces.hasPath("tls_certificate_path")) {
            return new File(this.interfaces.getString("tls_certificate_path")).toPath();
        }
        return null;
    }

    @Nullable
    private Path parseTlsKeyPath() {
        if (this.interfaces.hasPath("tls_key_path")) {
            return new File(this.interfaces.getString("tls_key_path")).toPath();
        }
        return null;
    }

    private URI parseRestListenUri() {
        return URI.create(this.interfaces.getString("rest_listen_uri"));
    }

    private URI parseHttpExternalUri() {
        return URI.create(this.interfaces.getString("http_external_uri"));
    }

    private Integer parseAlertingTrainingPeriodSeconds() {
        return this.alerting.getInt("training_period_seconds");
    }

    private ImmutableList<Dot11TrapDeviceDefinition> parseDot11TrapDeviceDefinitions() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (Config config : this.root.getConfigList("802_11_traps")) {
            if (!Dot11TrapDeviceDefinition.checkConfig(config)) {
                LOG.info("Skipping 802.11 trap device definition with invalid configuration. Invalid definition: [{}]", (Object)config);
                continue;
            }
            Config trapConfig = config.getConfig("trap");
            Dot11TrapConfiguration trap = Dot11TrapConfiguration.create(Trap.Type.valueOf(trapConfig.getString("type")), trapConfig);
            boolean skipEnableMonitor = config.hasPath("skip_enable_monitor") ? config.getBoolean("skip_enable_monitor") : false;
            result.add(Dot11TrapDeviceDefinition.create(config.getString("device"), config.getIntList("channels"), config.getString("channel_hop_command"), config.getInt("channel_hop_interval"), skipEnableMonitor, trap));
        }
        return result.build();
    }

    private ImmutableList<Alert.TYPE_WIDE> parseDot11Alerts() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        for (String alert : this.root.getStringList("802_11_alerts")) {
            String name = alert.toUpperCase();
            if (!Enums.getIfPresent(Alert.TYPE_WIDE.class, name).isPresent()) continue;
            result.add((Object)Alert.TYPE_WIDE.valueOf(name));
        }
        return result.build();
    }

    private ImmutableList<AlertCallback> parseAlertCallbacks() {
        ImmutableList.Builder callbacks = new ImmutableList.Builder();
        if (!this.alerting.hasPath("callbacks")) {
            return callbacks.build();
        }
        try {
            List<? extends Config> cs2 = this.alerting.getConfigList("callbacks");
            block10: for (Config config : cs2) {
                if (!config.hasPath("type") || !config.hasPath("enabled")) {
                    LOG.error("Alert callback is missing type or enabled field. Please consult callback documentation.");
                    continue;
                }
                String type = config.getString("type");
                if (!config.getBoolean("enabled")) {
                    LOG.info("Skipping disabled alert callback of type [{}].", (Object)type);
                    continue;
                }
                switch (type) {
                    case "email": {
                        callbacks.add(new EmailCallback(EmailCallback.parseConfiguration(config, this.parseHttpExternalUri().toString())));
                        continue block10;
                    }
                    case "file": {
                        callbacks.add(new FileCallback(FileCallback.parseConfiguration(config)));
                    }
                }
                LOG.error("Skipping unknown alert callback of type [{}].", (Object)type);
            }
        }
        catch (Exception e2) {
            LOG.error("Could not parse alert callbacks", (Throwable)e2);
            return callbacks.build();
        }
        return callbacks.build();
    }

    @Nullable
    private UplinkDeviceConfiguration parseGroundstationDevice() {
        if (!this.root.hasPath("groundstation_device")) {
            return null;
        }
        Config trackerDevice = this.root.getConfig("groundstation_device");
        if (trackerDevice.hasPath("type")) {
            return UplinkDeviceConfiguration.create(trackerDevice.getString("type"), trackerDevice.getConfig("parameters"));
        }
        return null;
    }

    private ImmutableList<ForwarderDefinition> parseForwarders() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        if (this.root.hasPath("forwarders")) {
            for (Config config : this.root.getConfigList("forwarders")) {
                result.add(ForwarderDefinition.create(config.getString("type"), config.getConfig("configuration")));
            }
        }
        return result.build();
    }

    private void validate() throws IncompleteConfigurationException, InvalidConfigurationException {
        Config reporting;
        Config groundstationDevice;
        ConfigurationValidator.expectEnum(this.general, "role", "general", Role.class);
        ConfigurationValidator.expect(this.general, "admin_password_hash", "general", String.class);
        ConfigurationValidator.expect(this.general, "database_path", "general", String.class);
        ConfigurationValidator.expect(this.general, "versionchecks", "general", Boolean.class);
        ConfigurationValidator.expect(this.general, "fetch_ouis", "general", Boolean.class);
        ConfigurationValidator.expect(this.python, "path", "general.python", String.class);
        ConfigurationValidator.expect(this.python, "script_directory", "general.python", String.class);
        ConfigurationValidator.expect(this.python, "script_prefix", "general.python", String.class);
        ConfigurationValidator.expect(this.alerting, "training_period_seconds", "general.alerting", Integer.class);
        ConfigurationValidator.expect(this.interfaces, "rest_listen_uri", "interfaces", String.class);
        ConfigurationValidator.expect(this.interfaces, "http_external_uri", "interfaces", String.class);
        ConfigurationValidator.expect(this.root, "802_11_monitors", "<root>", List.class);
        ConfigurationValidator.expect(this.root, "802_11_networks", "<root>", List.class);
        ConfigurationValidator.expect(this.root, "802_11_alerts", "<root>", List.class);
        ConfigurationValidator.expect(this.root, "groundstation_device", "<root>", Config.class);
        if (this.root.hasPath("uplinks")) {
            ConfigurationValidator.expect(this.root, "uplinks", "<root>", List.class);
            int i2 = 0;
            for (Config config : this.root.getConfigList("uplinks")) {
                ConfigurationValidator.expect(config, "type", "uplinks.#" + i2, String.class);
                ConfigurationValidator.expect(config, "configuration", "uplinks.#" + i2, Config.class);
            }
        }
        if (this.root.hasPath("forwarders")) {
            ConfigurationValidator.expect(this.root, "forwarders", "<root>", List.class);
            int i2 = 0;
            for (Config config : this.root.getConfigList("forwarders")) {
                ConfigurationValidator.expect(config, "type", "forwarders.#" + i2, String.class);
                ConfigurationValidator.expect(config, "configuration", "forwarders.#" + i2, Config.class);
            }
        }
        if (this.root.hasPath("remote_input")) {
            Config remoteInput = this.root.getConfig("remote_input");
            ConfigurationValidator.expect(remoteInput, "host", "remote_input", String.class);
            ConfigurationValidator.expect(remoteInput, "port", "remote_input", Integer.class);
        }
        if (this.root.hasPath("groundstation_device") && (groundstationDevice = this.root.getConfig("groundstation_device")).hasPath("type")) {
            ConfigurationValidator.expect(groundstationDevice, "type", "groundstation_device", String.class);
            ConfigurationValidator.expect(groundstationDevice, "parameters", "groundstation_device", Config.class);
            if (groundstationDevice.getString("type").equals(TrackerDevice.TYPE.SX126X_LORA.toString())) {
                Config loraConfig = groundstationDevice.getConfig("parameters");
                ConfigurationValidator.expect(loraConfig, "serial_port", "groundstation_device.parameters", String.class);
                String string = loraConfig.getString("serial_port");
                if (!new File(string).exists()) {
                    throw new InvalidConfigurationException("Parameter groundstation_device.parameters.serial_port does not point to an existing serial port path at [" + string + "].");
                }
                ConfigurationValidator.expect(loraConfig, "encryption_key", "groundstation_device.parameters", String.class);
                String string2 = loraConfig.getString("encryption_key");
                if (string2.length() != 32) {
                    throw new InvalidConfigurationException("Parameter groundstation_device.parameters.encryption_key must be exactly 32 characters long.");
                }
            }
        }
        if (this.root.hasPath("reporting") && (reporting = this.root.getConfig("reporting")).hasPath("email")) {
            Config email = reporting.getConfig("email");
            String string = "reporting.email";
            ConfigurationValidator.expect(email, "transport_strategy", string, String.class);
            ConfigurationValidator.expect(email, "host", string, String.class);
            ConfigurationValidator.expect(email, "port", string, Integer.class);
            ConfigurationValidator.expect(email, "username", string, String.class);
            ConfigurationValidator.expect(email, "password", string, String.class);
            ConfigurationValidator.expect(email, "from", string, String.class);
            ConfigurationValidator.expect(email, "subject_prefix", string, String.class);
            try {
                TransportStrategy.valueOf(email.getString("transport_strategy"));
            }
            catch (IllegalArgumentException e2) {
                throw new InvalidConfigurationException("Invalid reporting SMTP transport strategy.", e2);
            }
            Tools.parseEmailAddress(email.getString("from"));
        }
        if (this.root.hasPath("deauth_monitor")) {
            Config deauth = this.root.getConfig("deauth_monitor");
            ConfigurationValidator.expect(deauth, "global_threshold", "deauth_monitor", Integer.class);
        }
        if (this.parseAdminPasswordHash().length() != 64) {
            throw new InvalidConfigurationException("Parameter [general.admin_password_hash] must be 64 characters long (a SHA256 hash).");
        }
        this.baseDot11ConfigurationLoader.validate();
        int i3 = 0;
        List trapDevices = Lists.newArrayList();
        for (Config config : this.root.getConfigList("802_11_traps")) {
            String where = "802_11_traps.#" + i3;
            ConfigurationValidator.expect(config, "device", where, String.class);
            ConfigurationValidator.expect(config, "channels", where, List.class);
            ConfigurationValidator.expect(config, "channel_hop_command", where, String.class);
            ConfigurationValidator.expect(config, "channel_hop_interval", where, Integer.class);
            ConfigurationValidator.expect(config, "trap", where, Config.class);
            String deviceName = config.getString("device");
            Config trap = config.getConfig("trap");
            ConfigurationValidator.expect(trap, "type", where, String.class);
            String trapType = trap.getString("type");
            try {
                Trap.Type.valueOf(trapType);
            }
            catch (IllegalArgumentException e3) {
                throw new InvalidConfigurationException("Trap [" + where + "] is of invalid type [" + trapType + "].");
            }
            if (trapDevices.contains(deviceName)) {
                throw new InvalidConfigurationException("Trap [" + where + "] is using already configured device [" + deviceName + "]. Devices can only be used once.");
            }
            trapDevices.add(deviceName);
            for (Dot11MonitorDefinition monitor : this.baseDot11ConfigurationLoader.parseDot11Monitors()) {
                if (!monitor.device().equals(deviceName)) continue;
                throw new InvalidConfigurationException("Trap [" + where + "] is using already configured monitor device [" + deviceName + "]. Devices can only be used once.");
            }
        }
        if (!Files.isExecutable(new File(this.parsePythonExecutable()).toPath())) {
            throw new InvalidConfigurationException("Parameter [general.python.path] does not point to an executable file: " + this.parsePythonExecutable());
        }
        if (!Files.isDirectory(new File(this.parsePythonScriptDirectory()).toPath(), new LinkOption[0]) || !Files.isWritable(new File(this.parsePythonScriptDirectory()).toPath())) {
            throw new InvalidConfigurationException("Parameter [general.python.script_directory] does not point to a writable directory: " + this.parsePythonScriptDirectory());
        }
        try {
            this.parseRestListenUri();
        }
        catch (Exception exception) {
            LOG.error(exception);
            throw new InvalidConfigurationException("Parameter [interfaces.rest_listen_uri] cannot be parsed into a URI. Make sure it is correct.");
        }
        try {
            this.parseHttpExternalUri();
        }
        catch (Exception exception) {
            LOG.error(exception);
            throw new InvalidConfigurationException("Parameter [interfaces.http_external_uri] cannot be parsed into a URI. Make sure it is correct.");
        }
        if (this.parseUseTls()) {
            try {
                Path path = this.parseTlsCertificatePath();
                if (!path.toFile().canRead()) {
                    throw new InvalidConfigurationException("Parameter [interfaces.tls_certificate_path] points to a file that is not readable.");
                }
            }
            catch (Exception exception) {
                LOG.error(exception);
                throw new InvalidConfigurationException("Parameter [interfaces.tls_certificate_path] cannot be parsed into a path. Make sure it is correct.");
            }
            try {
                Path path = this.parseTlsKeyPath();
                if (!path.toFile().canRead()) {
                    throw new InvalidConfigurationException("Parameter [interfaces.tls_key_path] points to a file that is not readable.");
                }
            }
            catch (Exception exception) {
                LOG.error(exception);
                throw new InvalidConfigurationException("Parameter [interfaces.tls_key_path] cannot be parsed into a path. Make sure it is correct.");
            }
        }
    }
}

