/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.typesafe.config.Config;
import horse.wtf.nzyme.configuration.AutoValue_Dot11TrapDeviceDefinition;
import horse.wtf.nzyme.configuration.Dot11TrapConfiguration;
import java.util.List;

@AutoValue
public abstract class Dot11TrapDeviceDefinition {
    public abstract String device();

    public abstract List<Integer> channels();

    public abstract String channelHopCommand();

    public abstract int channelHopInterval();

    public abstract boolean skipEnableMonitor();

    public abstract Dot11TrapConfiguration trap();

    public static Dot11TrapDeviceDefinition create(String device, List<Integer> channels, String channelHopCommand, int channelHopInterval, boolean skipEnableMonitor, Dot11TrapConfiguration trap) {
        return Dot11TrapDeviceDefinition.builder().device(device).channels(channels).channelHopCommand(channelHopCommand).channelHopInterval(channelHopInterval).skipEnableMonitor(skipEnableMonitor).trap(trap).build();
    }

    @JsonIgnore
    public static boolean checkConfig(Config c2) {
        return !Strings.isNullOrEmpty(c2.getString("device")) && !Strings.isNullOrEmpty(c2.getString("channel_hop_command")) && c2.getInt("channel_hop_interval") >= 0 && c2.getIntList("channels") != null && !c2.getIntList("channels").isEmpty() && c2.getConfig("trap") != null;
    }

    public static Builder builder() {
        return new AutoValue_Dot11TrapDeviceDefinition.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder device(String var1);

        public abstract Builder channels(List<Integer> var1);

        public abstract Builder channelHopCommand(String var1);

        public abstract Builder channelHopInterval(int var1);

        public abstract Builder trap(Dot11TrapConfiguration var1);

        public abstract Builder skipEnableMonitor(boolean var1);

        public abstract Dot11TrapDeviceDefinition build();
    }
}

