/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.configuration;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import horse.wtf.nzyme.configuration.IncompleteConfigurationException;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigurationValidator {
    private static final Logger LOG = LogManager.getLogger(ConfigurationValidator.class);

    public static void expect(Config c2, String key, String where, Class clazz) throws IncompleteConfigurationException, InvalidConfigurationException {
        boolean incomplete = false;
        boolean invalid = false;
        try {
            if (clazz.equals(String.class)) {
                incomplete = Strings.isNullOrEmpty(c2.getString(key));
            }
            if (clazz.equals(Boolean.class)) {
                c2.getBoolean(key);
            }
            if (clazz.equals(ImmutableList.class)) {
                c2.getList(key);
            }
            if (clazz.equals(Integer.class)) {
                c2.getInt(key);
            }
        }
        catch (ConfigException.Missing e2) {
            LOG.error(e2);
            incomplete = true;
        }
        catch (ConfigException.WrongType e3) {
            LOG.error(e3);
            invalid = true;
        }
        catch (ConfigException e4) {
            LOG.error(e4);
            throw new InvalidConfigurationException("Parsing error for parameter [" + key + "] in section [" + where + "].");
        }
        if (incomplete) {
            throw new IncompleteConfigurationException("Missing parameter [" + key + "] in section [" + where + "].");
        }
        if (invalid) {
            throw new InvalidConfigurationException("Invalid value for parameter [" + key + "] in section [" + where + "].");
        }
    }

    public static void expectEnum(Config c2, String key, String where, Class enumClazz) throws InvalidConfigurationException, IncompleteConfigurationException {
        try {
            c2.getEnum(enumClazz, key);
        }
        catch (ConfigException.Missing e2) {
            throw new IncompleteConfigurationException("Missing parameter [" + key + "] in section [" + where + "].");
        }
        catch (ConfigException.BadValue e3) {
            LOG.error(e3);
            throw new InvalidConfigurationException("Invalid value for parameter [" + key + "] in section [" + where + "].");
        }
    }
}

