/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers.trackerlogic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.NzymeTracker;
import horse.wtf.nzyme.bandits.Bandit;
import horse.wtf.nzyme.bandits.engine.ContactIdentifierEngine;
import horse.wtf.nzyme.bandits.engine.ContactIdentifierProcess;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifierFactory;
import horse.wtf.nzyme.bandits.trackers.TrackerTrackSummary;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public class TrackerBanditManager
implements ContactIdentifierProcess {
    private static final Logger LOG = LogManager.getLogger(TrackerBanditManager.class);
    private NzymeTracker nzyme;
    private Bandit currentlyTrackedBandit;
    private final ContactIdentifierEngine identifierEngine;
    private final List<InitialTrackHandler> initialTrackHandlers;
    private final List<BanditTraceHandler> traceHandlers;
    private UUID currentTrack;
    private long currentTrackFrameCount = 0L;
    private DateTime currentTrackLastContact;
    private int currentTrackSignal = 0;

    public TrackerBanditManager(NzymeTracker nzyme) {
        this.nzyme = nzyme;
        this.initialTrackHandlers = Lists.newArrayList();
        this.traceHandlers = Lists.newArrayList();
        this.identifierEngine = new ContactIdentifierEngine(nzyme.getMetrics());
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("contact-retention-%d").build()).scheduleWithFixedDelay(() -> {
            if (this.isCurrentlyTracking() && this.currentTrackLastContact.isBefore(DateTime.now().minusMinutes(5))) {
                LOG.info("Track timeout exceeded. Resetting.");
                this.resetCurrentTrack();
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    @Override
    @Nullable
    public Bandit getCurrentlyTrackedBandit() {
        return this.currentlyTrackedBandit;
    }

    public void setCurrentlyTrackedBandit(TrackerMessage.StartTrackRequest request) {
        UUID uuid = UUID.fromString(request.getUuid());
        if (this.currentlyTrackedBandit != null && this.currentlyTrackedBandit.uuid().equals(uuid)) {
            LOG.info("Already tracking bandit [{}].", (Object)uuid);
            return;
        }
        try {
            ArrayList<BanditIdentifier> identifiers = Lists.newArrayList();
            for (TrackerMessage.ContactIdentifier broadcastedIdentifier : request.getIdentifierList()) {
                HashMap<String, Object> parsedConfiguration = Maps.newHashMap();
                for (String s2 : broadcastedIdentifier.getConfigurationList()) {
                    String json;
                    int cPos = s2.indexOf(":");
                    String key = s2.substring(0, cPos);
                    String value = s2.substring(cPos + 2, s2.length() - 1);
                    if (value.startsWith("nzl:")) {
                        json = value.substring(4);
                        parsedConfiguration.put(key, this.nzyme.getObjectMapper().readValue(json, List.class));
                        continue;
                    }
                    if (value.startsWith("nzm:")) {
                        json = value.substring(4);
                        parsedConfiguration.put(key, this.nzyme.getObjectMapper().readValue(json, Map.class));
                        continue;
                    }
                    parsedConfiguration.put(key, value);
                }
                identifiers.add(BanditIdentifierFactory.create(BanditIdentifier.TYPE.valueOf(broadcastedIdentifier.getType()), parsedConfiguration, null, UUID.fromString(broadcastedIdentifier.getUuid())));
            }
            LOG.info("Setting currently tracked bandit to [{}].", (Object)uuid);
            this.currentlyTrackedBandit = this.buildBandit(uuid, identifiers);
        }
        catch (BanditIdentifierFactory.MappingException | BanditIdentifierFactory.NoSerializerException | IOException e2) {
            LOG.error("Invalid bandit identifier payload in bandit broadcast.", (Throwable)e2);
        }
    }

    public boolean isCurrentlyTracking() {
        return this.currentlyTrackedBandit != null;
    }

    private Bandit buildBandit(UUID uuid, List<BanditIdentifier> identifiers) {
        return Bandit.create(null, uuid, "n/a", "n/a", false, DateTime.now(), DateTime.now(), identifiers);
    }

    public void cancelTracking() {
        if (!this.isCurrentlyTracking()) {
            LOG.warn("Received request to cancel tracking but currently not tracking. Ignoring.");
            return;
        }
        LOG.info("Canceling tracking of bandit.");
        this.currentlyTrackedBandit = null;
        this.resetCurrentTrack();
    }

    private void resetCurrentTrack() {
        LOG.info("Resetting current track.");
        this.currentTrack = null;
        this.currentTrackFrameCount = 0L;
        this.currentTrackLastContact = null;
    }

    @Override
    public void identify(Dot11Frame frame) {
        Optional<ContactIdentifierEngine.ContactIdentification> result;
        if (!this.isCurrentlyTracking()) {
            return;
        }
        Bandit bandit = this.getCurrentlyTrackedBandit();
        if (bandit.identifiers() != null && !bandit.identifiers().isEmpty() && (result = this.identifierEngine.identify(frame, bandit)).isPresent()) {
            if (this.currentTrack == null) {
                this.currentTrack = UUID.randomUUID();
                for (InitialTrackHandler initialTrackHandler : this.initialTrackHandlers) {
                    initialTrackHandler.handle(bandit);
                }
                LOG.info("Initial contact with tracked bandit. Starting track [{}].", (Object)this.currentTrack.toString().substring(0, 6));
            }
            ++this.currentTrackFrameCount;
            this.currentTrackSignal = frame.meta().getAntennaSignal();
            this.currentTrackLastContact = DateTime.now();
            for (BanditTraceHandler banditTraceHandler : this.traceHandlers) {
                banditTraceHandler.handle(bandit, frame.meta().getAntennaSignal(), frame.meta().getChannel());
            }
        }
    }

    public boolean hasActiveTrack() {
        return this.isCurrentlyTracking() && this.currentTrack != null;
    }

    @Nullable
    public TrackerTrackSummary getTrackSummary() {
        if (!this.hasActiveTrack()) {
            return null;
        }
        return TrackerTrackSummary.create(this.currentTrack, this.currentTrackLastContact, this.currentTrackSignal, this.currentTrackFrameCount);
    }

    public void onInitialTrack(InitialTrackHandler handler) {
        this.initialTrackHandlers.add(handler);
    }

    public void onBanditTrace(BanditTraceHandler handler) {
        this.traceHandlers.add(handler);
    }

    public static interface BanditTraceHandler {
        public void handle(Bandit var1, int var2, int var3);
    }

    public static interface InitialTrackHandler {
        public void handle(Bandit var1);
    }
}

