/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.trackers.hid;

import horse.wtf.nzyme.bandits.Bandit;
import horse.wtf.nzyme.bandits.trackers.TrackerState;
import horse.wtf.nzyme.bandits.trackers.hid.TrackerHID;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogHID
implements TrackerHID {
    private static final Logger LOG = LogManager.getLogger(LogHID.class);

    @Override
    public void initialize() {
        LOG.info("LOG HID initialized.");
    }

    @Override
    public void onConnectionStateChange(List<TrackerState> connectionState) {
        LOG.info("Connection state changed: {}.", (Object)connectionState);
    }

    @Override
    public void onStartTrackingRequestReceived(TrackerMessage.StartTrackRequest request) {
        LOG.info("Received request to start tracking bandit [{}].", (Object)request.getUuid());
    }

    @Override
    public void onCancelTrackingRequestReceived(TrackerMessage.CancelTrackRequest request) {
        LOG.info("Received request to abort tracking bandit.");
    }

    @Override
    public void onInitialContactWithTrackedBandit(Bandit bandit) {
        LOG.info("Made initial contact with tracked bandit [{}].", (Object)bandit.uuid());
    }

    @Override
    public void onBanditTrace(Bandit bandit, int rssi) {
        LOG.info("Bandit trace at RSSI <{}>.", (Object)rssi);
    }

    @Override
    public void onChannelSwitch(int previousChannel, int newChannel) {
        LOG.info("Switching channel from [{}] to [{}].", (Object)previousChannel, (Object)newChannel);
    }

    @Override
    public void onPingFromLeaderReceived(TrackerMessage.Ping ping, int rssi) {
        LOG.info("Received ping from leader [{}] at RSSI <{}>.", (Object)ping.getSource(), (Object)rssi);
    }

    @Override
    public void onPingFromTrackerReceived(TrackerMessage.Ping ping, int rssi) {
        LOG.info("Received ping from tracker [{}] at RSSI <{}>.", (Object)ping.getSource(), (Object)rssi);
    }
}

