/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.identifiers;

import com.google.common.base.Strings;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifierDescriptor;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11DeauthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import horse.wtf.nzyme.dot11.interceptors.misc.PwnagotchiAdvertisement;
import horse.wtf.nzyme.dot11.misc.PwnagotchiAdvertisementExtractor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class PwnagotchiBanditIdentifier
extends BanditIdentifier {
    private final String identity;
    private final PwnagotchiAdvertisementExtractor extractor = new PwnagotchiAdvertisementExtractor();

    public PwnagotchiBanditIdentifier(String identity, Long databaseID, UUID uuid) {
        super(databaseID, uuid, BanditIdentifier.TYPE.PWNAGOTCHI_IDENTITY);
        this.identity = identity;
    }

    @Override
    public BanditIdentifierDescriptor descriptor() {
        return BanditIdentifierDescriptor.create(BanditIdentifier.TYPE.PWNAGOTCHI_IDENTITY, "Matches if the frame is a Pwnagotchi advertisement for the expected Pwnagotchi identity.", "frame.pwnagotchi_identity == \"" + this.identity + "\"");
    }

    @Override
    public Map<String, Object> configuration() {
        return new HashMap<String, Object>(){
            {
                this.put("identity", PwnagotchiBanditIdentifier.this.identity);
            }
        };
    }

    @Override
    public Optional<Boolean> matches(Dot11DeauthenticationFrame frame) {
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> matches(Dot11BeaconFrame frame) {
        Optional<PwnagotchiAdvertisement> result = this.extractor.extract(frame);
        return Optional.of(result.isPresent() && !Strings.isNullOrEmpty(result.get().identity()) && result.get().identity().equals(this.identity));
    }

    @Override
    public Optional<Boolean> matches(Dot11ProbeResponseFrame frame) {
        return Optional.empty();
    }
}

