/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.engine;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.math.Stats;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.bandits.engine.AutoValue_ContactRecorder_ComputationResult;
import horse.wtf.nzyme.bandits.engine.ContactRecord;
import horse.wtf.nzyme.util.Tools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.joda.time.DateTime;

public class ContactRecorder {
    private static final Logger LOG = LogManager.getLogger(ContactRecorder.class);
    private final Object mutex = new Object();
    private final NzymeLeader nzyme;
    private final Map<UUID, Map<String, List<Integer>>> ssids;
    private final Map<UUID, Map<String, List<Integer>>> bssids;

    public ContactRecorder(int cleaningFrequencySeconds, NzymeLeader nzyme) {
        this.nzyme = nzyme;
        this.ssids = Maps.newHashMap();
        this.bssids = Maps.newHashMap();
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("contactrecorder-sync-%d").build()).scheduleWithFixedDelay(() -> {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.writeToDatabase(ContactRecorder.compute(this.ssids), RECORD_TYPE.SSID);
                    this.writeToDatabase(ContactRecorder.compute(this.bssids), RECORD_TYPE.BSSID);
                }
                catch (Exception e2) {
                    LOG.error("Error in contact recorder synchronization.", (Throwable)e2);
                }
                finally {
                    this.ssids.clear();
                    this.bssids.clear();
                }
            }
        }, cleaningFrequencySeconds, cleaningFrequencySeconds, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordFrame(UUID contactUUID, int rssi, String bssid, Optional<String> ssid) {
        LOG.debug("Recording frame for [{}/{}] at RSSI {} and SSID {}", (Object)contactUUID, (Object)bssid, (Object)rssi, (Object)ssid);
        Object object = this.mutex;
        synchronized (object) {
            Map<String, List<Integer>> contactBSSID;
            if (!this.bssids.containsKey(contactUUID)) {
                this.bssids.put(contactUUID, Maps.newHashMap());
            }
            if (!(contactBSSID = this.bssids.get(contactUUID)).containsKey(bssid)) {
                contactBSSID.put(bssid, Lists.newArrayList());
            }
            contactBSSID.get(bssid).add(rssi);
            if (ssid.isPresent() && Tools.isHumanlyReadable(ssid.get())) {
                Map<String, List<Integer>> contactSSID;
                if (!this.ssids.containsKey(contactUUID)) {
                    this.ssids.put(contactUUID, Maps.newHashMap());
                }
                if (!(contactSSID = this.ssids.get(contactUUID)).containsKey(ssid.get())) {
                    contactSSID.put(ssid.get(), Lists.newArrayList());
                }
                contactSSID.get(ssid.get()).add(rssi);
            }
        }
    }

    public static Map<UUID, Map<String, ComputationResult>> compute(Map<UUID, Map<String, List<Integer>>> population) {
        HashMap<UUID, Map<String, ComputationResult>> result = Maps.newHashMap();
        for (Map.Entry<UUID, Map<String, List<Integer>>> contact : population.entrySet()) {
            HashMap<String, ComputationResult> entryResult = Maps.newHashMap();
            for (Map.Entry<String, List<Integer>> values2 : contact.getValue().entrySet()) {
                Stats stats = Stats.of((Iterable<? extends Number>)values2.getValue());
                entryResult.put(values2.getKey(), ComputationResult.create(values2.getValue().size(), stats.mean(), stats.populationStandardDeviation()));
            }
            result.put(contact.getKey(), entryResult);
        }
        return result;
    }

    public Map<UUID, Map<String, List<Integer>>> getSSIDs() {
        return Maps.newHashMap(this.ssids);
    }

    public Map<UUID, Map<String, List<Integer>>> getBSSIDs() {
        return Maps.newHashMap(this.bssids);
    }

    private void writeToDatabase(Map<UUID, Map<String, ComputationResult>> records, RECORD_TYPE recordType) {
        for (Map.Entry<UUID, Map<String, ComputationResult>> contact : records.entrySet()) {
            for (Map.Entry<String, ComputationResult> record : contact.getValue().entrySet()) {
                ComputationResult cr2 = record.getValue();
                this.nzyme.getDatabase().useHandle(handle -> ((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO contact_records(contact_uuid, record_type, record_value, frame_count, rssi_average, rssi_stddev, created_at) VALUES(:contact_uuid, :record_type, :record_value, :frame_count, :rssi_average, :rssi_stddev, :created_at)").bind("contact_uuid", (UUID)contact.getKey())).bind("record_type", (Object)recordType)).bind("record_value", (String)record.getKey())).bind("frame_count", cr2.frameCount())).bind("rssi_average", cr2.average())).bind("rssi_stddev", cr2.stdDev())).bind("created_at", (Object)DateTime.now())).execute());
            }
        }
    }

    public List<ContactRecord> findContactRecords(UUID contactUUID, RECORD_TYPE recordType) {
        return this.nzyme.getDatabase().withHandle(handle -> ((Query)((Query)handle.createQuery("SELECT contact_uuid, record_type, record_value, frame_count, rssi_average, rssi_stddev, created_at FROM contact_records WHERE contact_uuid = :contact_uuid AND record_type = :record_type ORDER BY created_at DESC").bind("contact_uuid", contactUUID)).bind("record_type", (Object)recordType)).mapTo(ContactRecord.class).list());
    }

    @AutoValue
    public static abstract class ComputationResult {
        public abstract long frameCount();

        public abstract double average();

        public abstract double stdDev();

        public static ComputationResult create(long frameCount, double average, double stdDev) {
            return ComputationResult.builder().frameCount(frameCount).average(average).stdDev(stdDev).build();
        }

        public static Builder builder() {
            return new AutoValue_ContactRecorder_ComputationResult.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder frameCount(long var1);

            public abstract Builder average(double var1);

            public abstract Builder stdDev(double var1);

            public abstract ComputationResult build();
        }
    }

    public static enum VALUE_TYPE {
        FRAME_COUNT,
        SIGNAL_STRENGTH;

    }

    public static enum RECORD_TYPE {
        SSID,
        BSSID;

    }
}

