/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits.engine;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import horse.wtf.nzyme.bandits.Identifiable;
import horse.wtf.nzyme.bandits.engine.AutoValue_ContactIdentifierEngine_ContactIdentification;
import horse.wtf.nzyme.bandits.identifiers.BanditIdentifier;
import horse.wtf.nzyme.dot11.frames.Dot11BeaconFrame;
import horse.wtf.nzyme.dot11.frames.Dot11DeauthenticationFrame;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import horse.wtf.nzyme.dot11.frames.Dot11ProbeResponseFrame;
import horse.wtf.nzyme.util.MetricNames;
import java.util.Optional;

public class ContactIdentifierEngine {
    private final Timer timing;

    public ContactIdentifierEngine(MetricRegistry metrics) {
        this.timing = metrics.timer(MetricNames.CONTACT_IDENTIFIER_TIMING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ContactIdentification> identify(Dot11Frame frame, Identifiable bandit) {
        if (bandit.identifiers() == null || bandit.identifiers().isEmpty()) {
            return Optional.empty();
        }
        Timer.Context timer = this.timing.time();
        try {
            for (BanditIdentifier identifier : bandit.identifiers()) {
                Dot11DeauthenticationFrame deauth;
                Dot11ProbeResponseFrame probeResponse;
                Dot11BeaconFrame beacon;
                Optional<Boolean> matches;
                if (frame instanceof Dot11BeaconFrame && (matches = identifier.matches(beacon = (Dot11BeaconFrame)frame)).isPresent() && matches.get().booleanValue()) {
                    if (Strings.isNullOrEmpty(beacon.ssid())) {
                        Optional<ContactIdentification> optional = Optional.of(ContactIdentification.create(beacon.transmitter(), Optional.empty()));
                        return optional;
                    }
                    Optional<ContactIdentification> optional = Optional.of(ContactIdentification.create(beacon.transmitter(), Optional.of(beacon.ssid())));
                    return optional;
                }
                if (frame instanceof Dot11ProbeResponseFrame && (matches = identifier.matches(probeResponse = (Dot11ProbeResponseFrame)frame)).isPresent() && matches.get().booleanValue()) {
                    if (Strings.isNullOrEmpty(probeResponse.ssid())) {
                        Optional<ContactIdentification> optional = Optional.of(ContactIdentification.create(probeResponse.transmitter(), Optional.empty()));
                        return optional;
                    }
                    Optional<ContactIdentification> optional = Optional.of(ContactIdentification.create(probeResponse.transmitter(), Optional.of(probeResponse.ssid())));
                    return optional;
                }
                if (!(frame instanceof Dot11DeauthenticationFrame) || !(matches = identifier.matches(deauth = (Dot11DeauthenticationFrame)frame)).isPresent() || !matches.get().booleanValue()) continue;
                Optional<ContactIdentification> optional = Optional.of(ContactIdentification.create(deauth.transmitter(), Optional.empty()));
                return optional;
            }
        }
        finally {
            timer.stop();
        }
        return Optional.empty();
    }

    @AutoValue
    public static abstract class ContactIdentification {
        public abstract String bssid();

        public abstract Optional<String> ssid();

        public static ContactIdentification create(String bssid, Optional<String> ssid) {
            return ContactIdentification.builder().bssid(bssid).ssid(ssid).build();
        }

        public static Builder builder() {
            return new AutoValue_ContactIdentifierEngine_ContactIdentification.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder bssid(String var1);

            public abstract Builder ssid(Optional<String> var1);

            public abstract ContactIdentification build();
        }
    }
}

