/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.bandits;

import com.google.auto.value.AutoValue;
import horse.wtf.nzyme.Role;
import horse.wtf.nzyme.bandits.AutoValue_Contact;
import horse.wtf.nzyme.bandits.Bandit;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

@AutoValue
public abstract class Contact {
    public abstract UUID uuid();

    public abstract DateTime firstSeen();

    public abstract DateTime lastSeen();

    public abstract Long frameCount();

    public abstract Role sourceRole();

    public abstract String sourceName();

    public abstract int lastSignal();

    @Nullable
    public abstract Long banditId();

    @Nullable
    public abstract Bandit bandit();

    public boolean isActive() {
        return this.lastSeen().isAfter(DateTime.now().minusMinutes(5));
    }

    public static Contact create(UUID uuid, DateTime firstSeen, DateTime lastSeen, Long frameCount, Role sourceRole, String sourceName, int lastSignal, Long banditId, Bandit bandit) {
        return Contact.builder().uuid(uuid).firstSeen(firstSeen).lastSeen(lastSeen).frameCount(frameCount).sourceRole(sourceRole).sourceName(sourceName).lastSignal(lastSignal).banditId(banditId).bandit(bandit).build();
    }

    public static Builder builder() {
        return new AutoValue_Contact.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder uuid(UUID var1);

        public abstract Builder firstSeen(DateTime var1);

        public abstract Builder lastSeen(DateTime var1);

        public abstract Builder frameCount(Long var1);

        public abstract Builder sourceRole(Role var1);

        public abstract Builder sourceName(String var1);

        public abstract Builder lastSignal(int var1);

        public abstract Builder banditId(Long var1);

        public abstract Builder bandit(Bandit var1);

        public abstract Contact build();
    }
}

