/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts.service.callbacks;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.auto.value.AutoValue;
import com.typesafe.config.Config;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.service.callbacks.AlertCallback;
import horse.wtf.nzyme.alerts.service.callbacks.AutoValue_FileCallback_Configuration;
import horse.wtf.nzyme.configuration.ConfigurationValidator;
import horse.wtf.nzyme.configuration.IncompleteConfigurationException;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FileCallback
implements AlertCallback {
    private final Path path;
    private Object mutex = new Object();
    private static final String WHERE = "alerting.callbacks.[file]";

    public FileCallback(Configuration config) {
        this.path = config.path();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void call(Alert alert) {
        String payload;
        try {
            payload = alert.toJSONString();
        }
        catch (JsonProcessingException e2) {
            throw new RuntimeException("Could not transform alert to JSON.", e2);
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!Files.exists(this.path, new LinkOption[0])) {
                try {
                    Files.createFile(this.path, new FileAttribute[0]);
                }
                catch (IOException e3) {
                    throw new RuntimeException("Could not create alert callback file.", e3);
                }
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.path.toFile(), true);
                out.write(payload.getBytes());
                out.write("\n".getBytes());
            }
            catch (Exception e4) {
                throw new RuntimeException("Could not write to alert callback file.", e4);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e5) {
                        throw new RuntimeException(e5);
                    }
                }
            }
        }
    }

    public static Configuration parseConfiguration(Config c2) throws InvalidConfigurationException, IncompleteConfigurationException {
        Path filePath;
        ConfigurationValidator.expect(c2, "path", WHERE, String.class);
        try {
            filePath = new File(c2.getString("path")).toPath();
        }
        catch (Exception e2) {
            throw new InvalidConfigurationException("Could not build path to file.", e2);
        }
        if (Files.exists(filePath, new LinkOption[0]) && !Files.isWritable(filePath)) {
            throw new InvalidConfigurationException("File [" + filePath + "] exists but is not writable.");
        }
        return Configuration.create(filePath);
    }

    @AutoValue
    public static abstract class Configuration {
        public abstract Path path();

        public static Configuration create(Path path) {
            return Configuration.builder().path(path).build();
        }

        public static Builder builder() {
            return new AutoValue_FileCallback_Configuration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder path(Path var1);

            public abstract Configuration build();
        }
    }
}

