/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class UnknownSSIDAlert
extends Alert {
    private static final String DESCRIPTION = "An SSID (network name) that has not been seen before was detected. Nzyme keeps a list of networks it has seen and this alert was triggered because a previously unknown network was advertised. Note that this is very often a legitimate network (see false positives below) and should be treated as a notice that needs further human investigation to determine if it is a potential threat or not.";
    private static final String DOC_LINK = "guidance-UNKNOWN_SSID";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("A new and legitimate network might have been enabled by someone in the vicinity.");
            this.add("A legitimate network could have been in range temporarily. A common example is a car with smart functionality that brings its own WiFi network passing through the coverage area of nzyme.");
        }
    };

    private UnknownSSIDAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, false, 0L);
    }

    @Override
    public String getMessage() {
        return "New SSID [" + this.getSSID() + "] detected.";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.UNKNOWN_SSID;
    }

    public String getSSID() {
        return (String)this.getFields().get("ssid");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof UnknownSSIDAlert)) {
            return false;
        }
        UnknownSSIDAlert a2 = (UnknownSSIDAlert)alert;
        return a2.getSSID().equals(this.getSSID());
    }

    public static UnknownSSIDAlert create(DateTime firstSeen, @NotNull String ssid, String bssid, int channel, int frequency, int antennaSignal) {
        if (Strings.isNullOrEmpty(ssid)) {
            throw new IllegalArgumentException("This alert cannot be raised for hidden/broadcast SSIDs.");
        }
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("ssid", ssid);
        fields.put("bssid", bssid.toLowerCase());
        fields.put("channel", channel);
        fields.put("frequency", frequency);
        fields.put("antenna_signal", antennaSignal);
        return new UnknownSSIDAlert(firstSeen, Subsystem.DOT_11, fields.build());
    }
}

