/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class UnexpectedSSIDBeaconAlert
extends Alert {
    private static final String DESCRIPTION = "One of our stations is advertising a SSID (network name) that we did not expect. An attacker might have gained access to access point configuration and could have created a new wireless network. This alert can also indicate actions of an attacker who is not careful with the spoofing of BSSIDs (hardware addresses) of access points.";
    private static final String DOC_LINK = "guidance-UNEXPECTED_BEACON_SSID";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("A new network (for example, a guest network) was created by a legitimate administrator and the nzyme configuration has not been updated yet.");
        }
    };

    private UnexpectedSSIDBeaconAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields, long frameCount) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, true, frameCount);
    }

    @Override
    public String getMessage() {
        return "Our BSSID [" + this.getBSSID() + "] advertised unexpected SSID [" + this.getSSID() + "] with beacon frame.";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.UNEXPECTED_SSID_BEACON;
    }

    public String getSSID() {
        return (String)this.getFields().get("ssid");
    }

    public String getBSSID() {
        return (String)this.getFields().get("bssid");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof UnexpectedSSIDBeaconAlert)) {
            return false;
        }
        UnexpectedSSIDBeaconAlert a2 = (UnexpectedSSIDBeaconAlert)alert;
        return a2.getSSID().equals(this.getSSID()) && a2.getBSSID().equals(this.getBSSID());
    }

    public static UnexpectedSSIDBeaconAlert create(DateTime firstSeen, @NotNull String ssid, String bssid, int channel, int frequency, int antennaSignal, long frameCount) {
        if (Strings.isNullOrEmpty(ssid)) {
            throw new IllegalArgumentException("This alert cannot be raised for hidden/broadcast SSIDs.");
        }
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("ssid", ssid);
        fields.put("bssid", bssid.toLowerCase());
        fields.put("channel", channel);
        fields.put("frequency", frequency);
        fields.put("antenna_signal", antennaSignal);
        return new UnexpectedSSIDBeaconAlert(firstSeen, Subsystem.DOT_11, fields.build(), frameCount);
    }
}

