/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class MultipleTrackAlert
extends Alert {
    private static final String DESCRIPTION = "One of our stations is transmitting with more than one signal track. This could indicate that an attacker is spoofing the station, causing a different signal strength than the legitimate station. If this is an attacker, the difference in signal strength is usually caused by different physical locations of attacker and legitimate station.";
    private static final String DOC_LINK = "guidance-MULTIPLE_TRACKS";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("A sudden change in the physical radio frequency environment can cause new tracks to appear. Monitor the signal track behavior long-term to spot normal changes in track behavior.");
            this.add("A station with adaptive transmit power can cause new tracks to be detected.");
            this.add("A physical relocation or configuration change of the station can cause the signal strength to change and new tracks to appear.");
        }
    };

    private MultipleTrackAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, false, -1L);
    }

    @Override
    public String getMessage() {
        return "Multiple tracks detected for our SSID [" + this.getSSID() + "] on [" + this.getBSSID() + "], channel [" + this.getChannel() + "]. Tracks: " + this.getTrackCount();
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.MULTIPLE_SIGNAL_TRACKS;
    }

    public String getSSID() {
        return (String)this.getFields().get("ssid");
    }

    public String getBSSID() {
        return (String)this.getFields().get("bssid");
    }

    public int getChannel() {
        return (Integer)this.getFields().get("channel");
    }

    public int getTrackCount() {
        return (Integer)this.getFields().get("track_count");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof MultipleTrackAlert)) {
            return false;
        }
        MultipleTrackAlert a2 = (MultipleTrackAlert)alert;
        return a2.getSSID().equals(this.getSSID()) && a2.getBSSID().equals(this.getBSSID()) && a2.getChannel() == this.getChannel();
    }

    public static MultipleTrackAlert create(DateTime firstSeen, @NotNull String ssid, String bssid, int channel, int trackCount) {
        if (Strings.isNullOrEmpty(ssid)) {
            throw new IllegalArgumentException("This alert cannot be raised for hidden/broadcast SSIDs.");
        }
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("ssid", ssid);
        fields.put("bssid", bssid.toLowerCase());
        fields.put("channel", channel);
        fields.put("track_count", trackCount);
        return new MultipleTrackAlert(firstSeen, Subsystem.DOT_11, fields.build());
    }
}

