/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class CryptoChangeProbeRespAlert
extends Alert {
    private static final String DESCRIPTION = "A station is replying to devices that are looking for one of our networks (probing) and is using an unexpected wireless security mechanism. This could indicate that an attacker is spoofing your SSID (network name) but does not know the correct password. Without the correct password, clients will not connect. The attacker might be trying to simply leave out the password (note that most modern devices will refuse to connect to a network that used to have a password but suddenly does not have one) or try a downgrade attack to exploit less secure mechanisms. It could also indicate spoofing without attempting to properly replicate the original security mechanisms.";
    private static final String DOC_LINK = "guidance-CRYPTO_CHANGE";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("A legitimate configuration change of an access point could have caused this.");
        }
    };

    private CryptoChangeProbeRespAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields, long frameCount) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, true, frameCount);
    }

    @Override
    public String getMessage() {
        return "SSID [" + this.getSSID() + "] was advertised with unexpected security settings [" + this.getEncounteredSecurity() + "].";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.CRYPTO_CHANGE_PROBERESP;
    }

    public String getSSID() {
        return (String)this.getFields().get("ssid");
    }

    public String getBSSID() {
        return (String)this.getFields().get("bssid");
    }

    public String getEncounteredSecurity() {
        return (String)this.getFields().get("encountered_security");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof CryptoChangeProbeRespAlert)) {
            return false;
        }
        CryptoChangeProbeRespAlert a2 = (CryptoChangeProbeRespAlert)alert;
        return a2.getSSID().equals(this.getSSID()) && a2.getBSSID().equals(this.getBSSID()) && a2.getEncounteredSecurity().equals(this.getEncounteredSecurity());
    }

    public static CryptoChangeProbeRespAlert create(DateTime firstSeen, @NotNull String ssid, String bssid, String encounteredSecurity, int channel, int frequency, int antennaSignal, long frameCount) {
        if (Strings.isNullOrEmpty(ssid)) {
            throw new IllegalArgumentException("This alert cannot be raised for hidden/broadcast SSIDs.");
        }
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("ssid", ssid);
        fields.put("bssid", bssid.toLowerCase());
        fields.put("encountered_security", encounteredSecurity);
        fields.put("channel", channel);
        fields.put("frequency", frequency);
        fields.put("antenna_signal", antennaSignal);
        return new CryptoChangeProbeRespAlert(firstSeen, Subsystem.DOT_11, fields.build(), frameCount);
    }
}

