/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.dot11.deception.traps.Trap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class BeaconTrapResponseAlert
extends Alert {
    private static final String DESCRIPTION = "A device responded to our beacon trap (" + Trap.Type.BEACON_1 + "). This clearly indicates that an attacker is trying to lure another device to connect to their rogue access point.";
    private static final String DOC_LINK = "guidance-TRAP_BEACON_1";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("This can only be a false positive if you used a legitimate SSID in the trap configuration.");
        }
    };

    private BeaconTrapResponseAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields, long frameCount) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, true, frameCount);
    }

    @Override
    public String getMessage() {
        return "Device [" + this.getBSSID() + "] responded to our beacon trap (" + Trap.Type.BEACON_1 + ") for [" + this.getSSID() + "].";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.BEACON_TRAP_1;
    }

    public String getSSID() {
        return (String)this.getFields().get("ssid");
    }

    public String getBSSID() {
        return (String)this.getFields().get("bssid");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof BeaconTrapResponseAlert)) {
            return false;
        }
        BeaconTrapResponseAlert a2 = (BeaconTrapResponseAlert)alert;
        return a2.getSSID().equals(this.getSSID()) && a2.getBSSID().equals(this.getBSSID());
    }

    public static BeaconTrapResponseAlert create(DateTime firstSeen, @NotNull String ssid, String bssid, int channel, int frequency, int antennaSignal, long frameCount) {
        if (Strings.isNullOrEmpty(ssid)) {
            throw new IllegalArgumentException("This alert cannot be raised for hidden/broadcast SSIDs.");
        }
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("ssid", ssid);
        fields.put("bssid", bssid.toLowerCase());
        fields.put("channel", channel);
        fields.put("frequency", frequency);
        fields.put("antenna_signal", antennaSignal);
        return new BeaconTrapResponseAlert(firstSeen, Subsystem.DOT_11, fields.build(), frameCount);
    }
}

