/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.joda.time.DateTime;

public class BanditContactAlert
extends Alert {
    private static final String DESCRIPTION = "Nzyme detected a bandit contact.";
    private static final String DOC_LINK = "guidance-BANDIT_CONTACT";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("A mis-configured or too wide bandit definition could trigger an invalid contact.");
        }
    };

    private BanditContactAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields, long frameCount) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, true, frameCount);
    }

    @Override
    public String getMessage() {
        if (this.getFields().containsKey("ssid")) {
            return "Bandit [" + this.getBanditName() + "] detected, advertising [" + this.getFields().get("ssid") + "].";
        }
        return "Bandit [" + this.getBanditName() + "] detected.";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.BANDIT_CONTACT;
    }

    public String getBanditName() {
        return (String)this.getFields().get("bandit_name");
    }

    public String getBanditUUID() {
        return (String)this.getFields().get("bandit_uuid");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof BanditContactAlert)) {
            return false;
        }
        BanditContactAlert a2 = (BanditContactAlert)alert;
        if (this.getFields().containsKey("ssid")) {
            if (!a2.getFields().containsKey("ssid")) {
                return false;
            }
            if (!this.getFields().get("ssid").equals(a2.getFields().get("ssid"))) {
                return false;
            }
        }
        return a2.getBanditUUID().equals(this.getBanditUUID());
    }

    public static BanditContactAlert create(DateTime firstSeen, String banditName, String banditUUID, Optional<String> ssid, long frameCount) {
        ImmutableMap.Builder<String, String> fields = new ImmutableMap.Builder<String, String>();
        fields.put("bandit_name", banditName);
        fields.put("bandit_uuid", banditUUID);
        if (ssid.isPresent() && !Strings.isNullOrEmpty(ssid.get())) {
            fields.put("ssid", ssid.get());
        }
        return new BanditContactAlert(firstSeen, Subsystem.DOT_11, fields.build(), frameCount);
    }
}

