/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.BanditContactAlert;
import horse.wtf.nzyme.alerts.BeaconRateAnomalyAlert;
import horse.wtf.nzyme.alerts.BeaconTrapResponseAlert;
import horse.wtf.nzyme.alerts.CryptoChangeBeaconAlert;
import horse.wtf.nzyme.alerts.CryptoChangeProbeRespAlert;
import horse.wtf.nzyme.alerts.DeauthFloodAlert;
import horse.wtf.nzyme.alerts.MultipleTrackAlert;
import horse.wtf.nzyme.alerts.ProbeFailureAlert;
import horse.wtf.nzyme.alerts.ProbeRequestTrapResponseAlert;
import horse.wtf.nzyme.alerts.PwnagotchiAdvertisementAlert;
import horse.wtf.nzyme.alerts.UnexpectedBSSIDBeaconAlert;
import horse.wtf.nzyme.alerts.UnexpectedBSSIDProbeRespAlert;
import horse.wtf.nzyme.alerts.UnexpectedChannelBeaconAlert;
import horse.wtf.nzyme.alerts.UnexpectedChannelProbeRespAlert;
import horse.wtf.nzyme.alerts.UnexpectedFingerprintBeaconAlert;
import horse.wtf.nzyme.alerts.UnexpectedFingerprintProbeRespAlert;
import horse.wtf.nzyme.alerts.UnexpectedSSIDBeaconAlert;
import horse.wtf.nzyme.alerts.UnexpectedSSIDProbeRespAlert;
import horse.wtf.nzyme.alerts.UnknownSSIDAlert;
import horse.wtf.nzyme.alerts.service.AlertDatabaseEntry;
import horse.wtf.nzyme.dot11.interceptors.misc.PwnagotchiAdvertisement;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public abstract class Alert {
    public static final List<TYPE_WIDE> HIDDEN_IN_UI = ImmutableList.of(TYPE_WIDE.PROBE_RESPONSE_TRAP_1, TYPE_WIDE.BEACON_TRAP_1, TYPE_WIDE.PROBE_FAILURE);
    private final Subsystem subsystem;
    private final Map<String, Object> fields;
    private final DateTime firstSeen;
    private final AtomicReference<DateTime> lastSeen;
    private final AtomicLong frameCount;
    private final boolean useFrameCount;
    private final ObjectMapper objectMapper;
    private final String description;
    private final String documentationLink;
    private final List<String> falsePositives;
    protected UUID uuid;

    public abstract String getMessage();

    public abstract TYPE getType();

    public abstract boolean sameAs(Alert var1);

    protected Alert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields, String description, String documentationLink, List<String> falsePositives, boolean useFrameCount, long frameCount) {
        this.firstSeen = timestamp;
        this.lastSeen = new AtomicReference<DateTime>(timestamp);
        this.subsystem = subsystem;
        this.fields = ImmutableMap.copyOf(fields);
        this.description = description;
        this.documentationLink = documentationLink;
        this.falsePositives = falsePositives;
        this.useFrameCount = useFrameCount;
        this.frameCount = new AtomicLong(frameCount);
        this.objectMapper = new ObjectMapper();
    }

    public DateTime getFirstSeen() {
        return this.firstSeen;
    }

    public DateTime getLastSeen() {
        return this.lastSeen.get();
    }

    public void setLastSeen(DateTime timestamp) {
        this.lastSeen.set(timestamp);
    }

    public void incrementFrameCount() {
        this.frameCount.incrementAndGet();
    }

    @Nullable
    public Long getFrameCount() {
        return this.useFrameCount ? Long.valueOf(this.frameCount.get()) : null;
    }

    public boolean isUseFrameCount() {
        return this.useFrameCount;
    }

    public Subsystem getSubsystem() {
        return this.subsystem;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDocumentationLink() {
        return this.documentationLink;
    }

    public List<String> getFalsePositives() {
        return this.falsePositives;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public String toJSONString() throws JsonProcessingException {
        HashMap<String, Object> payload = Maps.newHashMap();
        payload.put("first_seen", this.getFirstSeen().toString());
        payload.put("last_seen", this.getLastSeen().toString());
        payload.put("frame_count", this.getFrameCount());
        payload.put("is_use_frame_count", this.isUseFrameCount());
        payload.put("message", this.getMessage());
        payload.put("type", (Object)this.getType());
        payload.put("subsystem", (Object)this.getSubsystem());
        payload.put("documentation_link", this.getDocumentationLink());
        payload.put("description", this.getDescription());
        payload.put("fields", this.getFields());
        payload.put("false_positives", this.getFalsePositives());
        return this.objectMapper.writeValueAsString(payload);
    }

    public static Alert serializeFromDatabase(AlertDatabaseEntry db2) throws IOException {
        Alert alert;
        ObjectMapper om = new ObjectMapper();
        Map<String, Object> fields = om.readValue(db2.fields(), new TypeReference<Map<String, Object>>(){});
        switch (db2.type()) {
            case UNEXPECTED_BSSID_BEACON: {
                alert = UnexpectedBSSIDBeaconAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case UNEXPECTED_BSSID_PROBERESP: {
                alert = UnexpectedBSSIDProbeRespAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (String)fields.get("destination"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case UNEXPECTED_SSID_BEACON: {
                alert = UnexpectedSSIDBeaconAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case UNEXPECTED_SSID_PROBERESP: {
                alert = UnexpectedSSIDProbeRespAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case CRYPTO_CHANGE_BEACON: {
                alert = CryptoChangeBeaconAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (String)fields.get("encountered_security"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case CRYPTO_CHANGE_PROBERESP: {
                alert = CryptoChangeProbeRespAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (String)fields.get("encountered_security"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case UNEXPECTED_CHANNEL_BEACON: {
                alert = UnexpectedChannelBeaconAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case UNEXPECTED_CHANNEL_PROBERESP: {
                alert = UnexpectedChannelProbeRespAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case UNEXPECTED_FINGERPRINT_BEACON: {
                alert = UnexpectedFingerprintBeaconAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bandit_fingerprint"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case UNEXPECTED_FINGERPRINT_PROBERESP: {
                alert = UnexpectedFingerprintProbeRespAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bandit_fingerprint"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case BEACON_RATE_ANOMALY: {
                alert = BeaconRateAnomalyAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (Double)fields.get("beacon_rate"), (Integer)fields.get("beacon_rate_threshold"));
                break;
            }
            case PROBE_RESPONSE_TRAP_1: {
                alert = ProbeRequestTrapResponseAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case MULTIPLE_SIGNAL_TRACKS: {
                alert = MultipleTrackAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("track_count"));
                break;
            }
            case PWNAGOTCHI_ADVERTISEMENT: {
                alert = PwnagotchiAdvertisementAlert.create(db2.firstSeen(), PwnagotchiAdvertisement.create((String)fields.get("name"), (String)fields.get("version"), (String)fields.get("identity"), (Double)fields.get("uptime"), (Integer)fields.get("pwnd_this_run"), (Integer)fields.get("pwnd_total")), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case BANDIT_CONTACT: {
                Optional<String> ssid = fields.containsKey("ssid") ? Optional.of((String)fields.get("ssid")) : Optional.empty();
                alert = BanditContactAlert.create(db2.firstSeen(), (String)fields.get("bandit_name"), (String)fields.get("bandit_uuid"), ssid, db2.frameCount());
                break;
            }
            case BEACON_TRAP_1: {
                alert = BeaconTrapResponseAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"), db2.frameCount());
                break;
            }
            case UNKNOWN_SSID: {
                alert = UnknownSSIDAlert.create(db2.firstSeen(), (String)fields.get("ssid"), (String)fields.get("bssid"), (Integer)fields.get("channel"), (Integer)fields.get("frequency"), (Integer)fields.get("antenna_signal"));
                break;
            }
            case PROBE_FAILURE: {
                alert = ProbeFailureAlert.create(db2.firstSeen(), (String)fields.get("probe_name"), (String)fields.get("error_description"));
                break;
            }
            case DEAUTH_FLOOD: {
                alert = DeauthFloodAlert.create(db2.firstSeen(), (Integer)fields.get("deauth_rate"), (Integer)fields.get("global_threshold"));
                break;
            }
            default: {
                throw new RuntimeException("Cannot serialize persisted alert of type [" + db2.type() + "]. Not implemented.");
            }
        }
        alert.setLastSeen(db2.lastSeen());
        alert.setUUID(db2.uuid());
        return alert;
    }

    public static enum TYPE {
        UNEXPECTED_BSSID_BEACON,
        UNEXPECTED_BSSID_PROBERESP,
        UNEXPECTED_SSID_BEACON,
        UNEXPECTED_SSID_PROBERESP,
        CRYPTO_CHANGE_BEACON,
        CRYPTO_CHANGE_PROBERESP,
        UNEXPECTED_CHANNEL_BEACON,
        UNEXPECTED_CHANNEL_PROBERESP,
        UNEXPECTED_FINGERPRINT_BEACON,
        UNEXPECTED_FINGERPRINT_PROBERESP,
        BEACON_RATE_ANOMALY,
        PROBE_RESPONSE_TRAP_1,
        MULTIPLE_SIGNAL_TRACKS,
        PWNAGOTCHI_ADVERTISEMENT,
        BANDIT_CONTACT,
        BEACON_TRAP_1,
        UNKNOWN_SSID,
        DEAUTH_FLOOD,
        PROBE_FAILURE;

    }

    public static enum TYPE_WIDE {
        UNEXPECTED_BSSID,
        UNEXPECTED_SSID,
        CRYPTO_CHANGE,
        UNEXPECTED_CHANNEL,
        UNEXPECTED_FINGERPRINT,
        BEACON_RATE_ANOMALY,
        PROBE_RESPONSE_TRAP_1,
        MULTIPLE_SIGNAL_TRACKS,
        PWNAGOTCHI_ADVERTISEMENT,
        BANDIT_CONTACT,
        BEACON_TRAP_1,
        UNKNOWN_SSID,
        DEAUTH_FLOOD,
        PROBE_FAILURE;

    }
}

