/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.Registry;
import horse.wtf.nzyme.Version;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.service.AlertsService;
import horse.wtf.nzyme.bandits.engine.ContactManager;
import horse.wtf.nzyme.bandits.trackers.GroundStation;
import horse.wtf.nzyme.bandits.trackers.TrackerManager;
import horse.wtf.nzyme.configuration.IncompleteConfigurationException;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import horse.wtf.nzyme.configuration.leader.LeaderConfiguration;
import horse.wtf.nzyme.configuration.leader.LeaderConfigurationLoader;
import horse.wtf.nzyme.database.Database;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.clients.Clients;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import horse.wtf.nzyme.dot11.networks.Networks;
import horse.wtf.nzyme.dot11.networks.sentry.Sentry;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import horse.wtf.nzyme.events.EventService;
import horse.wtf.nzyme.events.ShutdownEvent;
import horse.wtf.nzyme.events.StartupEvent;
import horse.wtf.nzyme.notifications.Notification;
import horse.wtf.nzyme.notifications.Uplink;
import horse.wtf.nzyme.ouis.OUIManager;
import horse.wtf.nzyme.processing.FrameProcessor;
import horse.wtf.nzyme.remote.forwarders.Forwarder;
import horse.wtf.nzyme.scheduler.SchedulingService;
import horse.wtf.nzyme.systemstatus.SystemStatus;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.security.Key;
import java.util.Collections;
import java.util.List;
import liquibase.exception.LiquibaseException;

public class MockNzyme
implements NzymeLeader {
    private final String nodeID;
    private final LeaderConfiguration configuration;
    private final SystemStatus systemStatus;
    private final Networks networks;
    private final Clients clients;
    private final OUIManager ouiManager;
    private final MetricRegistry metricRegistry;
    private final AlertsService alertsService;
    private final ContactManager contactManager;
    private final Key signingKey;
    private final ObjectMapper objectMapper;
    private final Registry registry;
    private final Version version = new Version();
    private final Database database;
    private final List<Uplink> uplinks;
    private final List<Forwarder> forwarders;
    private final FrameProcessor frameProcessor;
    private final Anonymizer anonymizer;
    private final Sentry sentry;
    private final EventService eventService;

    private File loadFromResourceFile(String name) {
        URL resource = this.getClass().getClassLoader().getResource(name);
        if (resource == null) {
            throw new RuntimeException("test config file does not exist in resources");
        }
        return new File(resource.getFile());
    }

    public MockNzyme() {
        this(5);
    }

    public MockNzyme(int sentryInterval) {
        this.signingKey = Keys.secretKeyFor(SignatureAlgorithm.HS512);
        try {
            String configFile = "nzyme-test-complete-valid.conf.test";
            if (System.getProperty("os.name").startsWith("Windows")) {
                configFile = "nzyme-test-complete-valid-windows.conf.test";
                System.out.println("loading Windows nzyme configuration file");
            }
            this.configuration = new LeaderConfigurationLoader(this.loadFromResourceFile(configFile), false).get();
        }
        catch (IncompleteConfigurationException | InvalidConfigurationException | FileNotFoundException e2) {
            throw new RuntimeException("Could not load test config file from resources.", e2);
        }
        this.nodeID = "mocky-mock";
        this.uplinks = Lists.newArrayList();
        this.forwarders = Lists.newArrayList();
        this.frameProcessor = new FrameProcessor();
        this.database = new Database(this.configuration);
        try {
            this.database.initializeAndMigrate();
        }
        catch (LiquibaseException e3) {
            throw new RuntimeException(e3);
        }
        this.database.useHandle(handle -> handle.execute("TRUNCATE sentry_ssids", new Object[0]));
        this.metricRegistry = new MetricRegistry();
        this.registry = new Registry();
        this.systemStatus = new SystemStatus();
        this.networks = new Networks(this);
        this.clients = new Clients(this);
        this.ouiManager = new OUIManager(this);
        this.alertsService = new AlertsService(this);
        this.objectMapper = new ObjectMapper();
        this.contactManager = new ContactManager(this);
        this.anonymizer = new Anonymizer(false, "/tmp");
        this.sentry = new Sentry(this, sentryInterval);
        this.eventService = new EventService(this);
    }

    @Override
    public void initialize() {
        this.eventService.recordEvent(new StartupEvent());
    }

    @Override
    public void shutdown() {
        this.eventService.recordEvent(new ShutdownEvent());
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public FrameProcessor getFrameProcessor() {
        return this.frameProcessor;
    }

    @Override
    public Networks getNetworks() {
        return this.networks;
    }

    @Override
    public Sentry getSentry() {
        return this.sentry;
    }

    @Override
    public Clients getClients() {
        return this.clients;
    }

    @Override
    public void registerUplink(Uplink uplink) {
        this.uplinks.add(uplink);
    }

    @Override
    public void notifyUplinks(Notification notification, Dot11MetaInformation meta) {
        for (Uplink uplink : this.uplinks) {
            uplink.notify(notification, meta);
        }
    }

    @Override
    public void notifyUplinksOfAlert(Alert alert) {
        for (Uplink uplink : this.uplinks) {
            uplink.notifyOfAlert(alert);
        }
    }

    @Override
    public void forwardFrame(Dot11Frame frame) {
        for (Forwarder forwarder : this.forwarders) {
            forwarder.forward(frame);
        }
    }

    @Override
    public LeaderConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public MetricRegistry getMetrics() {
        return this.metricRegistry;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public List<Dot11Probe> getProbes() {
        return Collections.emptyList();
    }

    @Override
    public AlertsService getAlertsService() {
        return this.alertsService;
    }

    @Override
    public ContactManager getContactManager() {
        return this.contactManager;
    }

    @Override
    public List<String> getIgnoredFingerprints() {
        return Collections.emptyList();
    }

    @Override
    public void registerIgnoredFingerprint(String fingerprint) {
    }

    @Override
    public TrackerManager getTrackerManager() {
        return null;
    }

    @Override
    public GroundStation getGroundStation() {
        return null;
    }

    @Override
    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public SchedulingService getSchedulingService() {
        return null;
    }

    @Override
    public OUIManager getOUIManager() {
        return this.ouiManager;
    }

    @Override
    public Anonymizer getAnonymizer() {
        return this.anonymizer;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public Key getSigningKey() {
        return this.signingKey;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }
}

