/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme;

import com.beust.jcommander.JCommander;
import com.typesafe.config.ConfigException;
import horse.wtf.nzyme.Logging;
import horse.wtf.nzyme.NzymeLeaderImpl;
import horse.wtf.nzyme.NzymeTrackerImpl;
import horse.wtf.nzyme.configuration.CLIArguments;
import horse.wtf.nzyme.configuration.IncompleteConfigurationException;
import horse.wtf.nzyme.configuration.InvalidConfigurationException;
import horse.wtf.nzyme.configuration.base.BaseConfiguration;
import horse.wtf.nzyme.configuration.base.BaseConfigurationLoader;
import horse.wtf.nzyme.configuration.leader.LeaderConfiguration;
import horse.wtf.nzyme.configuration.leader.LeaderConfigurationLoader;
import horse.wtf.nzyme.configuration.tracker.TrackerConfiguration;
import horse.wtf.nzyme.configuration.tracker.TrackerConfigurationLoader;
import horse.wtf.nzyme.database.Database;
import java.io.File;
import java.io.FileNotFoundException;
import liquibase.exception.LiquibaseException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger LOG = LogManager.getLogger(Main.class);
    private static final int FAILURE = 1;

    public static void main(String[] argv) {
        CLIArguments cliArguments = new CLIArguments();
        JCommander.newBuilder().addObject(cliArguments).build().parse(argv);
        if (cliArguments.isDebugMode()) {
            Logging.setRootLoggerLevel(Level.DEBUG);
        }
        if (cliArguments.isTraceMode()) {
            Logging.setRootLoggerLevel(Level.TRACE);
        }
        BaseConfiguration baseConfiguration = null;
        try {
            baseConfiguration = new BaseConfigurationLoader(new File(cliArguments.getConfigFilePath())).get();
        }
        catch (ConfigException | InvalidConfigurationException e2) {
            LOG.error("Invalid baseconfiguration. Please refer to the example configuration file or documentation.", (Throwable)e2);
            System.exit(1);
        }
        catch (IncompleteConfigurationException e3) {
            LOG.error("Incomplete base configuration. Please refer to the example configuration file or documentation.", (Throwable)e3);
            System.exit(1);
        }
        catch (FileNotFoundException e4) {
            LOG.error("Could not read configuration file.", (Throwable)e4);
            System.exit(1);
        }
        switch (baseConfiguration.mode()) {
            case LEADER: {
                LeaderConfiguration leaderConfiguration = null;
                try {
                    leaderConfiguration = new LeaderConfigurationLoader(new File(cliArguments.getConfigFilePath()), false).get();
                }
                catch (ConfigException | InvalidConfigurationException e5) {
                    LOG.error("Invalid configuration. Please refer to the example configuration file or documentation.", (Throwable)e5);
                    System.exit(1);
                }
                catch (IncompleteConfigurationException e6) {
                    LOG.error("Incomplete configuration. Please refer to the example configuration file or documentation.", (Throwable)e6);
                    System.exit(1);
                }
                catch (FileNotFoundException e7) {
                    LOG.error("Could not read configuration file.", (Throwable)e7);
                    System.exit(1);
                }
                Database database = new Database(leaderConfiguration);
                try {
                    database.initializeAndMigrate();
                }
                catch (LiquibaseException e8) {
                    LOG.fatal("Error during database initialization and migration.", (Throwable)e8);
                    System.exit(1);
                }
                NzymeLeaderImpl nzyme = new NzymeLeaderImpl(baseConfiguration, leaderConfiguration, database);
                try {
                    nzyme.initialize();
                }
                catch (Exception e9) {
                    LOG.fatal("Could not initialize nzyme.", (Throwable)e9);
                    System.exit(1);
                }
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    Thread.currentThread().setName("shutdown-hook");
                    nzyme.shutdown();
                }));
                break;
            }
            case TRACKER: {
                TrackerConfiguration trackerConfiguration = null;
                try {
                    trackerConfiguration = new TrackerConfigurationLoader(new File(cliArguments.getConfigFilePath())).get();
                }
                catch (ConfigException | InvalidConfigurationException e10) {
                    LOG.error("Invalid configuration. Please refer to the example configuration file or documentation.", (Throwable)e10);
                    System.exit(1);
                }
                catch (IncompleteConfigurationException e11) {
                    LOG.error("Incomplete configuration. Please refer to the example configuration file or documentation.", (Throwable)e11);
                    System.exit(1);
                }
                catch (FileNotFoundException e12) {
                    LOG.error("Could not read configuration file.", (Throwable)e12);
                    System.exit(1);
                }
                NzymeTrackerImpl tracker = new NzymeTrackerImpl(baseConfiguration, trackerConfiguration);
                try {
                    tracker.initialize();
                    break;
                }
                catch (Exception e13) {
                    LOG.fatal("Could not initialize nzyme.", (Throwable)e13);
                    System.exit(1);
                }
            }
        }
        try {
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e14) {
            return;
        }
    }
}

