/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

@Deprecated
public class IdentityHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    public static final long serialVersionUID = 362498820763181265L;
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;
    private transient Set keySet = null;
    private transient Set entrySet = null;
    private transient Collection values = null;
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private static EmptyHashIterator emptyHashIterator = new EmptyHashIterator();

    public IdentityHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public IdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IdentityHashMap() {
        this(11, 0.75f);
    }

    public IdentityHashMap(Map t2) {
        this(Math.max(2 * t2.size(), 11), 0.75f);
        this.putAll(t2);
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry[] tab = this.table;
        if (value == null) {
            int i2 = tab.length;
            while (i2-- > 0) {
                Entry e2 = tab[i2];
                while (e2 != null) {
                    if (e2.value == null) {
                        return true;
                    }
                    e2 = e2.next;
                }
            }
        } else {
            int i3 = tab.length;
            while (i3-- > 0) {
                Entry e3 = tab[i3];
                while (e3 != null) {
                    if (value.equals(e3.value)) {
                        return true;
                    }
                    e3 = e3.next;
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = System.identityHashCode(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e2 = tab[index];
            while (e2 != null) {
                if (e2.hash == hash && key == e2.key) {
                    return true;
                }
                e2 = e2.next;
            }
        } else {
            Entry e3 = tab[0];
            while (e3 != null) {
                if (e3.key == null) {
                    return true;
                }
                e3 = e3.next;
            }
        }
        return false;
    }

    public Object get(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = System.identityHashCode(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e2 = tab[index];
            while (e2 != null) {
                if (e2.hash == hash && key == e2.key) {
                    return e2.value;
                }
                e2 = e2.next;
            }
        } else {
            Entry e3 = tab[0];
            while (e3 != null) {
                if (e3.key == null) {
                    return e3.value;
                }
                e3 = e3.next;
            }
        }
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i2 = oldCapacity;
        while (i2-- > 0) {
            Entry old = oldMap[i2];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = (e2.hash & Integer.MAX_VALUE) % newCapacity;
                e2.next = newMap[index];
                newMap[index] = e2;
            }
        }
    }

    public Object put(Object key, Object value) {
        Entry e2;
        Entry[] tab = this.table;
        int hash = 0;
        int index = 0;
        if (key != null) {
            hash = System.identityHashCode(key);
            index = (hash & Integer.MAX_VALUE) % tab.length;
            e2 = tab[index];
            while (e2 != null) {
                if (e2.hash == hash && key == e2.key) {
                    Object old = e2.value;
                    e2.value = value;
                    return old;
                }
                e2 = e2.next;
            }
        } else {
            e2 = tab[0];
            while (e2 != null) {
                if (e2.key == null) {
                    Object old = e2.value;
                    e2.value = value;
                    return old;
                }
                e2 = e2.next;
            }
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e2 = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return null;
    }

    public Object remove(Object key) {
        Entry[] tab = this.table;
        if (key != null) {
            int hash = System.identityHashCode(key);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            Entry e2 = tab[index];
            Entry prev = null;
            while (e2 != null) {
                if (e2.hash == hash && key == e2.key) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e2.next;
                    } else {
                        tab[index] = e2.next;
                    }
                    --this.count;
                    Object oldValue = e2.value;
                    e2.value = null;
                    return oldValue;
                }
                prev = e2;
                e2 = e2.next;
            }
        } else {
            Entry e3 = tab[0];
            Entry prev = null;
            while (e3 != null) {
                if (e3.key == null) {
                    ++this.modCount;
                    if (prev != null) {
                        prev.next = e3.next;
                    } else {
                        tab[0] = e3.next;
                    }
                    --this.count;
                    Object oldValue = e3.value;
                    e3.value = null;
                    return oldValue;
                }
                prev = e3;
                e3 = e3.next;
            }
        }
        return null;
    }

    public void putAll(Map t2) {
        for (Map.Entry e2 : t2.entrySet()) {
            this.put(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    @Override
    public Object clone() {
        try {
            IdentityHashMap t2 = (IdentityHashMap)super.clone();
            t2.table = new Entry[this.table.length];
            int i2 = this.table.length;
            while (i2-- > 0) {
                t2.table[i2] = this.table[i2] != null ? (Entry)this.table[i2].clone() : null;
            }
            t2.keySet = null;
            t2.entrySet = null;
            t2.values = null;
            t2.modCount = 0;
            return t2;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(0);
                }

                @Override
                public int size() {
                    return IdentityHashMap.this.count;
                }

                @Override
                public boolean contains(Object o2) {
                    return IdentityHashMap.this.containsKey(o2);
                }

                @Override
                public boolean remove(Object o2) {
                    int oldSize = IdentityHashMap.this.count;
                    IdentityHashMap.this.remove(o2);
                    return IdentityHashMap.this.count != oldSize;
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(1);
                }

                @Override
                public int size() {
                    return IdentityHashMap.this.count;
                }

                @Override
                public boolean contains(Object o2) {
                    return IdentityHashMap.this.containsValue(o2);
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return IdentityHashMap.this.getHashIterator(2);
                }

                @Override
                public boolean contains(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object key = entry.getKey();
                    Entry[] tab = IdentityHashMap.this.table;
                    int hash = key == null ? 0 : System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e2 = tab[index];
                    while (e2 != null) {
                        if (e2.hash == hash && e2.equals(entry)) {
                            return true;
                        }
                        e2 = e2.next;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o2) {
                    if (!(o2 instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o2;
                    Object key = entry.getKey();
                    Entry[] tab = IdentityHashMap.this.table;
                    int hash = key == null ? 0 : System.identityHashCode(key);
                    int index = (hash & Integer.MAX_VALUE) % tab.length;
                    Entry e2 = tab[index];
                    Entry prev = null;
                    while (e2 != null) {
                        if (e2.hash == hash && e2.equals(entry)) {
                            IdentityHashMap.this.modCount++;
                            if (prev != null) {
                                prev.next = e2.next;
                            } else {
                                tab[index] = e2.next;
                            }
                            IdentityHashMap.this.count--;
                            e2.value = null;
                            return true;
                        }
                        prev = e2;
                        e2 = e2.next;
                    }
                    return false;
                }

                @Override
                public int size() {
                    return IdentityHashMap.this.count;
                }

                @Override
                public void clear() {
                    IdentityHashMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    private Iterator getHashIterator(int type) {
        if (this.count == 0) {
            return emptyHashIterator;
        }
        return new HashIterator(type);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        s2.writeInt(this.table.length);
        s2.writeInt(this.count);
        for (int index = this.table.length - 1; index >= 0; --index) {
            Entry entry = this.table[index];
            while (entry != null) {
                s2.writeObject(entry.key);
                s2.writeObject(entry.value);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int numBuckets = s2.readInt();
        this.table = new Entry[numBuckets];
        int size = s2.readInt();
        for (int i2 = 0; i2 < size; ++i2) {
            Object key = s2.readObject();
            Object value = s2.readObject();
            this.put(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    private class HashIterator
    implements Iterator {
        Entry[] table;
        int index;
        Entry entry;
        Entry lastReturned;
        int type;
        private int expectedModCount;

        HashIterator(int type) {
            this.table = IdentityHashMap.this.table;
            this.index = this.table.length;
            this.entry = null;
            this.lastReturned = null;
            this.expectedModCount = IdentityHashMap.this.modCount;
            this.type = type;
        }

        @Override
        public boolean hasNext() {
            Entry e2 = this.entry;
            int i2 = this.index;
            Entry[] t2 = this.table;
            while (e2 == null && i2 > 0) {
                e2 = t2[--i2];
            }
            this.entry = e2;
            this.index = i2;
            return e2 != null;
        }

        public Object next() {
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry et2 = this.entry;
            int i2 = this.index;
            Entry[] t2 = this.table;
            while (et2 == null && i2 > 0) {
                et2 = t2[--i2];
            }
            this.entry = et2;
            this.index = i2;
            if (et2 != null) {
                Entry e2 = this.lastReturned = this.entry;
                this.entry = e2.next;
                return this.type == 0 ? e2.key : (this.type == 1 ? e2.value : e2);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (IdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry[] tab = IdentityHashMap.this.table;
            int index = (this.lastReturned.hash & Integer.MAX_VALUE) % tab.length;
            Entry e2 = tab[index];
            Entry prev = null;
            while (e2 != null) {
                if (e2 == this.lastReturned) {
                    IdentityHashMap.this.modCount++;
                    ++this.expectedModCount;
                    if (prev == null) {
                        tab[index] = e2.next;
                    } else {
                        prev.next = e2.next;
                    }
                    IdentityHashMap.this.count--;
                    this.lastReturned = null;
                    return;
                }
                prev = e2;
                e2 = e2.next;
            }
            throw new ConcurrentModificationException();
        }
    }

    private static class EmptyHashIterator
    implements Iterator {
        EmptyHashIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class Entry
    implements Map.Entry {
        int hash;
        Object key;
        Object value;
        Entry next;

        Entry(int hash, Object key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        protected Object clone() {
            return new Entry(this.hash, this.key, this.value, this.next == null ? null : (Entry)this.next.clone());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return this.key == e2.getKey() && (this.value == null ? e2.getValue() == null : this.value.equals(e2.getValue()));
        }

        @Override
        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

