/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.jsp;

import freemarker.ext.jsp.FreeMarkerPageContext;
import freemarker.log.Logger;
import freemarker.template.utility.ClassUtil;
import java.util.LinkedList;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.el.ImplicitObjectELResolver;
import javax.servlet.jsp.el.ScopedAttributeELResolver;

class FreeMarkerJspApplicationContext
implements JspApplicationContext {
    private static final Logger LOG = Logger.getLogger("freemarker.jsp");
    private static final ExpressionFactory expressionFactoryImpl = FreeMarkerJspApplicationContext.findExpressionFactoryImplementation();
    private final LinkedList listeners = new LinkedList();
    private final CompositeELResolver elResolver = new CompositeELResolver();
    private final CompositeELResolver additionalResolvers = new CompositeELResolver();

    FreeMarkerJspApplicationContext() {
        this.elResolver.add((ELResolver)new ImplicitObjectELResolver());
        this.elResolver.add(this.additionalResolvers);
        this.elResolver.add(new MapELResolver());
        this.elResolver.add(new ResourceBundleELResolver());
        this.elResolver.add(new ListELResolver());
        this.elResolver.add(new ArrayELResolver());
        this.elResolver.add(new BeanELResolver());
        this.elResolver.add((ELResolver)new ScopedAttributeELResolver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addELContextListener(ELContextListener listener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.addLast(listener);
        }
    }

    private static ExpressionFactory findExpressionFactoryImplementation() {
        ExpressionFactory ef2 = FreeMarkerJspApplicationContext.tryExpressionFactoryImplementation("com.sun");
        if (ef2 == null && (ef2 = FreeMarkerJspApplicationContext.tryExpressionFactoryImplementation("org.apache")) == null) {
            LOG.warn("Could not find any implementation for " + ExpressionFactory.class.getName());
        }
        return ef2;
    }

    private static ExpressionFactory tryExpressionFactoryImplementation(String packagePrefix) {
        String className = packagePrefix + ".el.ExpressionFactoryImpl";
        try {
            Class cl2 = ClassUtil.forName(className);
            if (ExpressionFactory.class.isAssignableFrom(cl2)) {
                LOG.info("Using " + className + " as implementation of " + ExpressionFactory.class.getName());
                return (ExpressionFactory)cl2.newInstance();
            }
            LOG.warn("Class " + className + " does not implement " + ExpressionFactory.class.getName());
        }
        catch (ClassNotFoundException cl2) {
        }
        catch (Exception e2) {
            LOG.error("Failed to instantiate " + className, e2);
        }
        return null;
    }

    public void addELResolver(ELResolver resolver) {
        this.additionalResolvers.add(resolver);
    }

    public ExpressionFactory getExpressionFactory() {
        return expressionFactoryImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ELContext createNewELContext(FreeMarkerPageContext pageCtx) {
        FreeMarkerELContext ctx = new FreeMarkerELContext(pageCtx);
        ELContextEvent event = new ELContextEvent(ctx);
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            for (ELContextListener l2 : this.listeners) {
                l2.contextCreated(event);
            }
        }
        return ctx;
    }

    private class FreeMarkerELContext
    extends ELContext {
        private final FreeMarkerPageContext pageCtx;

        FreeMarkerELContext(FreeMarkerPageContext pageCtx) {
            this.pageCtx = pageCtx;
        }

        @Override
        public ELResolver getELResolver() {
            return FreeMarkerJspApplicationContext.this.elResolver;
        }

        @Override
        public FunctionMapper getFunctionMapper() {
            return null;
        }

        @Override
        public VariableMapper getVariableMapper() {
            return new VariableMapper(){

                @Override
                public ValueExpression resolveVariable(String name) {
                    Object obj = FreeMarkerELContext.this.pageCtx.findAttribute(name);
                    if (obj == null) {
                        return null;
                    }
                    return expressionFactoryImpl.createValueExpression(obj, obj.getClass());
                }

                @Override
                public ValueExpression setVariable(String name, ValueExpression value) {
                    ValueExpression prev = this.resolveVariable(name);
                    FreeMarkerELContext.this.pageCtx.setAttribute(name, value.getValue(FreeMarkerELContext.this));
                    return prev;
                }
            };
        }
    }
}

