/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BugException;
import freemarker.template.utility.StringUtil;

public final class _CoreStringUtils {
    private _CoreStringUtils() {
    }

    public static String toFTLIdentifierReferenceAfterDot(String name) {
        return _CoreStringUtils.backslashEscapeIdentifier(name);
    }

    public static String toFTLTopLevelIdentifierReference(String name) {
        return _CoreStringUtils.backslashEscapeIdentifier(name);
    }

    public static String toFTLTopLevelTragetIdentifier(String name) {
        int quotationType = 0;
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if ((i2 != 0 ? StringUtil.isFTLIdentifierPart(c2) : StringUtil.isFTLIdentifierStart(c2)) || c2 == '@') continue;
            if ((quotationType == 0 || quotationType == 92) && StringUtil.isBackslashEscapedFTLIdentifierCharacter(c2)) {
                quotationType = 92;
                continue;
            }
            quotationType = 34;
            break;
        }
        switch (quotationType) {
            case 0: {
                return name;
            }
            case 34: {
                return StringUtil.ftlQuote(name);
            }
            case 92: {
                return _CoreStringUtils.backslashEscapeIdentifier(name);
            }
        }
        throw new BugException();
    }

    public static String backslashEscapeIdentifier(String name) {
        StringBuilder sb = null;
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c2 = name.charAt(i2);
            if (StringUtil.isBackslashEscapedFTLIdentifierCharacter(c2)) {
                if (sb == null) {
                    sb = new StringBuilder(name.length() + 8);
                    sb.append(name, 0, i2);
                }
                sb.append('\\');
            }
            if (sb == null) continue;
            sb.append(c2);
        }
        return sb == null ? name : sb.toString();
    }

    public static int getIdentifierNamingConvention(String name) {
        int ln2 = name.length();
        for (int i2 = 0; i2 < ln2; ++i2) {
            char c2 = name.charAt(i2);
            if (c2 == '_') {
                return 11;
            }
            if (!_CoreStringUtils.isUpperUSASCII(c2)) continue;
            return 12;
        }
        return 10;
    }

    public static String camelCaseToUnderscored(String camelCaseName) {
        int i2;
        for (i2 = 0; i2 < camelCaseName.length() && Character.isLowerCase(camelCaseName.charAt(i2)); ++i2) {
        }
        if (i2 == camelCaseName.length()) {
            return camelCaseName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(camelCaseName.substring(0, i2));
        while (i2 < camelCaseName.length()) {
            char c2 = camelCaseName.charAt(i2);
            if (_CoreStringUtils.isUpperUSASCII(c2)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c2));
            } else {
                sb.append(c2);
            }
            ++i2;
        }
        return sb.toString();
    }

    public static boolean isUpperUSASCII(char c2) {
        return c2 >= 'A' && c2 <= 'Z';
    }
}

