/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.BuiltInForNumber;
import freemarker.core.Environment;
import freemarker.core.EvalUtil;
import freemarker.core._TemplateModelException;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.utility.NumberUtil;
import freemarker.template.utility.StringUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

class BuiltInsForNumbers {
    private static final BigDecimal BIG_DECIMAL_ONE = new BigDecimal("1");
    private static final BigDecimal BIG_DECIMAL_LONG_MIN = BigDecimal.valueOf(Long.MIN_VALUE);
    private static final BigDecimal BIG_DECIMAL_LONG_MAX = BigDecimal.valueOf(Long.MAX_VALUE);
    private static final BigInteger BIG_INTEGER_LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger BIG_INTEGER_LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);

    private static final long safeToLong(Number num) throws TemplateModelException {
        if (num instanceof Double) {
            double d2 = Math.round(num.doubleValue());
            if (d2 > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
                throw new _TemplateModelException("Number doesn't fit into a 64 bit signed integer (long): ", d2);
            }
            return (long)d2;
        }
        if (num instanceof Float) {
            float f2 = Math.round(num.floatValue());
            if (f2 > 9.223372E18f || f2 < -9.223372E18f) {
                throw new _TemplateModelException("Number doesn't fit into a 64 bit signed integer (long): ", Float.valueOf(f2));
            }
            return (long)f2;
        }
        if (num instanceof BigDecimal) {
            BigDecimal bd2 = ((BigDecimal)num).setScale(0, 4);
            if (bd2.compareTo(BIG_DECIMAL_LONG_MAX) > 0 || bd2.compareTo(BIG_DECIMAL_LONG_MIN) < 0) {
                throw new _TemplateModelException("Number doesn't fit into a 64 bit signed integer (long): ", bd2);
            }
            return bd2.longValue();
        }
        if (num instanceof BigInteger) {
            BigInteger bi2 = (BigInteger)num;
            if (bi2.compareTo(BIG_INTEGER_LONG_MAX) > 0 || bi2.compareTo(BIG_INTEGER_LONG_MIN) < 0) {
                throw new _TemplateModelException("Number doesn't fit into a 64 bit signed integer (long): ", bi2);
            }
            return bi2.longValue();
        }
        if (num instanceof Long || num instanceof Integer || num instanceof Byte || num instanceof Short) {
            return num.longValue();
        }
        throw new _TemplateModelException("Unsupported number type: ", num.getClass());
    }

    private BuiltInsForNumbers() {
    }

    static class shortBI
    extends BuiltInForNumber {
        shortBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Short) {
                return model;
            }
            return new SimpleNumber((Number)num.shortValue());
        }
    }

    static class roundBI
    extends BuiltInForNumber {
        private static final BigDecimal half = new BigDecimal("0.5");

        roundBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            return new SimpleNumber(new BigDecimal(num.doubleValue()).add(half).divide(BIG_DECIMAL_ONE, 0, 3));
        }
    }

    static class number_to_dateBI
    extends BuiltInForNumber {
        private final int dateType;

        number_to_dateBI(int dateType) {
            this.dateType = dateType;
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) throws TemplateModelException {
            return new SimpleDate(new Date(BuiltInsForNumbers.safeToLong(num)), this.dateType);
        }
    }

    static class longBI
    extends BuiltIn {
        longBI() {
        }

        @Override
        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel model = this.target.eval(env);
            if (!(model instanceof TemplateNumberModel) && model instanceof TemplateDateModel) {
                Date date = EvalUtil.modelToDate((TemplateDateModel)model, this.target);
                return new SimpleNumber(date.getTime());
            }
            Number num = this.target.modelToNumber(model, env);
            if (num instanceof Long) {
                return model;
            }
            return new SimpleNumber(num.longValue());
        }
    }

    static class is_nanBI
    extends BuiltInForNumber {
        is_nanBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) throws TemplateModelException {
            return NumberUtil.isNaN(num) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class is_infiniteBI
    extends BuiltInForNumber {
        is_infiniteBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) throws TemplateModelException {
            return NumberUtil.isInfinite(num) ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }

    static class intBI
    extends BuiltInForNumber {
        intBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Integer) {
                return model;
            }
            return new SimpleNumber(num.intValue());
        }
    }

    static class floorBI
    extends BuiltInForNumber {
        floorBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            return new SimpleNumber(new BigDecimal(num.doubleValue()).divide(BIG_DECIMAL_ONE, 0, 3));
        }
    }

    static class floatBI
    extends BuiltInForNumber {
        floatBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Float) {
                return model;
            }
            return new SimpleNumber(num.floatValue());
        }
    }

    static class doubleBI
    extends BuiltInForNumber {
        doubleBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Double) {
                return model;
            }
            return new SimpleNumber(num.doubleValue());
        }
    }

    static class ceilingBI
    extends BuiltInForNumber {
        ceilingBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            return new SimpleNumber(new BigDecimal(num.doubleValue()).divide(BIG_DECIMAL_ONE, 0, 2));
        }
    }

    static class byteBI
    extends BuiltInForNumber {
        byteBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) {
            if (num instanceof Byte) {
                return model;
            }
            return new SimpleNumber((Number)num.byteValue());
        }
    }

    static class absBI
    extends BuiltInForNumber {
        absBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) throws TemplateModelException {
            if (num instanceof Integer) {
                int n2 = num.intValue();
                if (n2 < 0) {
                    return new SimpleNumber(-n2);
                }
                return model;
            }
            if (num instanceof BigDecimal) {
                BigDecimal n3 = (BigDecimal)num;
                if (n3.signum() < 0) {
                    return new SimpleNumber(n3.negate());
                }
                return model;
            }
            if (num instanceof Double) {
                double n4 = num.doubleValue();
                if (n4 < 0.0) {
                    return new SimpleNumber(-n4);
                }
                return model;
            }
            if (num instanceof Float) {
                float n5 = num.floatValue();
                if (n5 < 0.0f) {
                    return new SimpleNumber(-n5);
                }
                return model;
            }
            if (num instanceof Long) {
                long n6 = num.longValue();
                if (n6 < 0L) {
                    return new SimpleNumber(-n6);
                }
                return model;
            }
            if (num instanceof Short) {
                short n7 = num.shortValue();
                if (n7 < 0) {
                    return new SimpleNumber((int)(-n7));
                }
                return model;
            }
            if (num instanceof Byte) {
                byte n8 = num.byteValue();
                if (n8 < 0) {
                    return new SimpleNumber((int)(-n8));
                }
                return model;
            }
            if (num instanceof BigInteger) {
                BigInteger n9 = (BigInteger)num;
                if (n9.signum() < 0) {
                    return new SimpleNumber(n9.negate());
                }
                return model;
            }
            throw new _TemplateModelException("Unsupported number class: ", num.getClass());
        }
    }

    static class upper_abcBI
    extends abcBI {
        upper_abcBI() {
        }

        @Override
        protected String toABC(int n2) {
            return StringUtil.toUpperABC(n2);
        }
    }

    static class lower_abcBI
    extends abcBI {
        lower_abcBI() {
        }

        @Override
        protected String toABC(int n2) {
            return StringUtil.toLowerABC(n2);
        }
    }

    private static abstract class abcBI
    extends BuiltInForNumber {
        private abcBI() {
        }

        @Override
        TemplateModel calculateResult(Number num, TemplateModel model) throws TemplateModelException {
            int n2;
            try {
                n2 = NumberUtil.toIntExact(num);
            }
            catch (ArithmeticException e2) {
                throw new _TemplateModelException(this.target, "The left side operand value isn't compatible with ?", this.key, ": ", e2.getMessage());
            }
            if (n2 <= 0) {
                throw new _TemplateModelException(this.target, "The left side operand of to ?", this.key, " must be at least 1, but was ", n2, ".");
            }
            return new SimpleScalar(this.toABC(n2));
        }

        protected abstract String toABC(int var1);
    }
}

