/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateLoaderUtils;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.utility.NullArgumentException;
import freemarker.template.utility.StringUtil;
import java.net.URL;

public class ClassTemplateLoader
extends URLTemplateLoader {
    private final Class<?> resourceLoaderClass;
    private final ClassLoader classLoader;
    private final String basePackagePath;

    @Deprecated
    public ClassTemplateLoader() {
        this(null, true, null, "/");
    }

    @Deprecated
    public ClassTemplateLoader(Class<?> resourceLoaderClass) {
        this(resourceLoaderClass, "");
    }

    public ClassTemplateLoader(Class<?> resourceLoaderClass, String basePackagePath) {
        this(resourceLoaderClass, false, null, basePackagePath);
    }

    public ClassTemplateLoader(ClassLoader classLoader, String basePackagePath) {
        this(null, true, classLoader, basePackagePath);
    }

    private ClassTemplateLoader(Class<?> resourceLoaderClass, boolean allowNullResourceLoaderClass, ClassLoader classLoader, String basePackagePath) {
        if (!allowNullResourceLoaderClass) {
            NullArgumentException.check("resourceLoaderClass", resourceLoaderClass);
        }
        NullArgumentException.check("basePackagePath", basePackagePath);
        Class<?> clazz = classLoader == null ? (resourceLoaderClass == null ? this.getClass() : resourceLoaderClass) : (this.resourceLoaderClass = null);
        if (this.resourceLoaderClass == null && classLoader == null) {
            throw new NullArgumentException("classLoader");
        }
        this.classLoader = classLoader;
        String canonBasePackagePath = ClassTemplateLoader.canonicalizePrefix(basePackagePath);
        if (this.classLoader != null && canonBasePackagePath.startsWith("/")) {
            canonBasePackagePath = canonBasePackagePath.substring(1);
        }
        this.basePackagePath = canonBasePackagePath;
    }

    @Override
    protected URL getURL(String name) {
        String fullPath = this.basePackagePath + name;
        if (this.basePackagePath.equals("/") && !ClassTemplateLoader.isSchemeless(fullPath)) {
            return null;
        }
        return this.resourceLoaderClass != null ? this.resourceLoaderClass.getResource(fullPath) : this.classLoader.getResource(fullPath);
    }

    private static boolean isSchemeless(String fullPath) {
        int i2 = 0;
        int ln2 = fullPath.length();
        if (i2 < ln2 && fullPath.charAt(i2) == '/') {
            ++i2;
        }
        while (i2 < ln2) {
            char c2 = fullPath.charAt(i2);
            if (c2 == '/') {
                return true;
            }
            if (c2 == ':') {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public String toString() {
        return TemplateLoaderUtils.getClassNameForToString(this) + "(" + (this.resourceLoaderClass != null ? "resourceLoaderClass=" + this.resourceLoaderClass.getName() : "classLoader=" + StringUtil.jQuote(this.classLoader)) + ", basePackagePath=" + StringUtil.jQuote(this.basePackagePath) + (this.resourceLoaderClass != null ? (this.basePackagePath.startsWith("/") ? "" : " /* relatively to resourceLoaderClass pkg */") : "") + ")";
    }

    public Class getResourceLoaderClass() {
        return this.resourceLoaderClass;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getBasePackagePath() {
        return this.basePackagePath;
    }
}

