/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.pool.ProxyConnection;
import com.zaxxer.hikari.pool.ProxyFactory;
import com.zaxxer.hikari.pool.ProxyResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;

public abstract class ProxyStatement
implements Statement {
    protected final ProxyConnection connection;
    protected final Statement delegate;
    private boolean isClosed;
    private ResultSet proxyResultSet;

    protected ProxyStatement(ProxyConnection connection, Statement statement) {
        this.connection = connection;
        this.delegate = statement;
    }

    final SQLException checkException(SQLException e2) {
        return this.connection.checkException(e2);
    }

    public final String toString() {
        String delegateToString = this.delegate.toString();
        return new StringBuilder(64 + delegateToString.length()).append(this.getClass().getSimpleName()).append('@').append(System.identityHashCode(this)).append(" wrapping ").append(delegateToString).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SQLException {
        ProxyStatement proxyStatement = this;
        synchronized (proxyStatement) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.connection.untrackStatement(this.delegate);
        try {
            this.delegate.close();
        }
        catch (SQLException e2) {
            throw this.connection.checkException(e2);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(sql, autoGeneratedKeys);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.connection.markCommitStateDirty();
        ResultSet resultSet = this.delegate.executeQuery(sql);
        return ProxyFactory.getProxyResultSet(this.connection, this, resultSet);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(sql);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.connection.markCommitStateDirty();
        return this.delegate.executeBatch();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(sql, columnNames);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        ResultSet resultSet = this.delegate.getResultSet();
        if (resultSet != null) {
            if (this.proxyResultSet == null || ((ProxyResultSet)this.proxyResultSet).delegate != resultSet) {
                this.proxyResultSet = ProxyFactory.getProxyResultSet(this.connection, this, resultSet);
            }
        } else {
            this.proxyResultSet = null;
        }
        return this.proxyResultSet;
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate instanceof Wrapper) {
            return this.delegate.unwrap(iface);
        }
        throw new SQLException("Wrapped statement is not an instance of " + iface);
    }
}

