/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config.impl;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigOrigin;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.impl.ConfigImplUtil;
import com.typesafe.config.impl.SimpleConfigOrigin;
import com.typesafe.config.impl.Token;
import com.typesafe.config.impl.Tokens;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

final class Tokenizer {
    Tokenizer() {
    }

    private static String asString(int codepoint) {
        if (codepoint == 10) {
            return "newline";
        }
        if (codepoint == 9) {
            return "tab";
        }
        if (codepoint == -1) {
            return "end of file";
        }
        if (ConfigImplUtil.isC0Control(codepoint)) {
            return String.format("control character 0x%x", codepoint);
        }
        return String.format("%c", codepoint);
    }

    static Iterator<Token> tokenize(ConfigOrigin origin, Reader input, ConfigSyntax flavor) {
        return new TokenIterator(origin, input, flavor != ConfigSyntax.JSON);
    }

    static String render(Iterator<Token> tokens) {
        StringBuilder renderedText = new StringBuilder();
        while (tokens.hasNext()) {
            renderedText.append(tokens.next().tokenText());
        }
        return renderedText.toString();
    }

    private static class TokenIterator
    implements Iterator<Token> {
        private final SimpleConfigOrigin origin;
        private final Reader input;
        private final LinkedList<Integer> buffer;
        private int lineNumber;
        private ConfigOrigin lineOrigin;
        private final Queue<Token> tokens;
        private final WhitespaceSaver whitespaceSaver;
        private final boolean allowComments;
        static final String firstNumberChars = "0123456789-";
        static final String numberChars = "0123456789eE+-.";
        static final String notInUnquotedText = "$\"{}[]:=,+#`^?!@*&\\";

        TokenIterator(ConfigOrigin origin, Reader input, boolean allowComments) {
            this.origin = (SimpleConfigOrigin)origin;
            this.input = input;
            this.allowComments = allowComments;
            this.buffer = new LinkedList();
            this.lineNumber = 1;
            this.lineOrigin = this.origin.withLineNumber(this.lineNumber);
            this.tokens = new LinkedList<Token>();
            this.tokens.add(Tokens.START);
            this.whitespaceSaver = new WhitespaceSaver();
        }

        private int nextCharRaw() {
            if (this.buffer.isEmpty()) {
                try {
                    return this.input.read();
                }
                catch (IOException e2) {
                    throw new ConfigException.IO(this.origin, "read error: " + e2.getMessage(), e2);
                }
            }
            int c2 = this.buffer.pop();
            return c2;
        }

        private void putBack(int c2) {
            if (this.buffer.size() > 2) {
                throw new ConfigException.BugOrBroken("bug: putBack() three times, undesirable look-ahead");
            }
            this.buffer.push(c2);
        }

        static boolean isWhitespace(int c2) {
            return ConfigImplUtil.isWhitespace(c2);
        }

        static boolean isWhitespaceNotNewline(int c2) {
            return c2 != 10 && ConfigImplUtil.isWhitespace(c2);
        }

        private boolean startOfComment(int c2) {
            if (c2 == -1) {
                return false;
            }
            if (this.allowComments) {
                if (c2 == 35) {
                    return true;
                }
                if (c2 == 47) {
                    int maybeSecondSlash = this.nextCharRaw();
                    this.putBack(maybeSecondSlash);
                    return maybeSecondSlash == 47;
                }
                return false;
            }
            return false;
        }

        private int nextCharAfterWhitespace(WhitespaceSaver saver) {
            int c2;
            while (true) {
                if ((c2 = this.nextCharRaw()) == -1) {
                    return -1;
                }
                if (!TokenIterator.isWhitespaceNotNewline(c2)) break;
                saver.add(c2);
            }
            return c2;
        }

        private ProblemException problem(String message) {
            return this.problem("", message, null);
        }

        private ProblemException problem(String what, String message) {
            return this.problem(what, message, null);
        }

        private ProblemException problem(String what, String message, boolean suggestQuotes) {
            return this.problem(what, message, suggestQuotes, null);
        }

        private ProblemException problem(String what, String message, Throwable cause) {
            return TokenIterator.problem(this.lineOrigin, what, message, cause);
        }

        private ProblemException problem(String what, String message, boolean suggestQuotes, Throwable cause) {
            return TokenIterator.problem(this.lineOrigin, what, message, suggestQuotes, cause);
        }

        private static ProblemException problem(ConfigOrigin origin, String what, String message, Throwable cause) {
            return TokenIterator.problem(origin, what, message, false, cause);
        }

        private static ProblemException problem(ConfigOrigin origin, String what, String message, boolean suggestQuotes, Throwable cause) {
            if (what == null || message == null) {
                throw new ConfigException.BugOrBroken("internal error, creating bad ProblemException");
            }
            return new ProblemException(Tokens.newProblem(origin, what, message, suggestQuotes, cause));
        }

        private static ProblemException problem(ConfigOrigin origin, String message) {
            return TokenIterator.problem(origin, "", message, null);
        }

        private static ConfigOrigin lineOrigin(ConfigOrigin baseOrigin, int lineNumber) {
            return ((SimpleConfigOrigin)baseOrigin).withLineNumber(lineNumber);
        }

        private Token pullComment(int firstChar) {
            boolean doubleSlash = false;
            if (firstChar == 47) {
                int discard = this.nextCharRaw();
                if (discard != 47) {
                    throw new ConfigException.BugOrBroken("called pullComment but // not seen");
                }
                doubleSlash = true;
            }
            StringBuilder sb = new StringBuilder();
            while (true) {
                int c2;
                if ((c2 = this.nextCharRaw()) == -1 || c2 == 10) {
                    this.putBack(c2);
                    if (doubleSlash) {
                        return Tokens.newCommentDoubleSlash(this.lineOrigin, sb.toString());
                    }
                    return Tokens.newCommentHash(this.lineOrigin, sb.toString());
                }
                sb.appendCodePoint(c2);
            }
        }

        private Token pullUnquotedText() {
            String s2;
            ConfigOrigin origin = this.lineOrigin;
            StringBuilder sb = new StringBuilder();
            int c2 = this.nextCharRaw();
            while (c2 != -1 && notInUnquotedText.indexOf(c2) < 0 && !TokenIterator.isWhitespace(c2) && !this.startOfComment(c2)) {
                sb.appendCodePoint(c2);
                if (sb.length() == 4) {
                    s2 = sb.toString();
                    if (s2.equals("true")) {
                        return Tokens.newBoolean(origin, true);
                    }
                    if (s2.equals("null")) {
                        return Tokens.newNull(origin);
                    }
                } else if (sb.length() == 5 && (s2 = sb.toString()).equals("false")) {
                    return Tokens.newBoolean(origin, false);
                }
                c2 = this.nextCharRaw();
            }
            this.putBack(c2);
            s2 = sb.toString();
            return Tokens.newUnquotedText(origin, s2);
        }

        private Token pullNumber(int firstChar) throws ProblemException {
            StringBuilder sb = new StringBuilder();
            sb.appendCodePoint(firstChar);
            boolean containedDecimalOrE = false;
            int c2 = this.nextCharRaw();
            while (c2 != -1 && numberChars.indexOf(c2) >= 0) {
                if (c2 == 46 || c2 == 101 || c2 == 69) {
                    containedDecimalOrE = true;
                }
                sb.appendCodePoint(c2);
                c2 = this.nextCharRaw();
            }
            this.putBack(c2);
            String s2 = sb.toString();
            try {
                if (containedDecimalOrE) {
                    return Tokens.newDouble(this.lineOrigin, Double.parseDouble(s2), s2);
                }
                return Tokens.newLong(this.lineOrigin, Long.parseLong(s2), s2);
            }
            catch (NumberFormatException e2) {
                for (char u2 : s2.toCharArray()) {
                    if (notInUnquotedText.indexOf(u2) < 0) continue;
                    throw this.problem(Tokenizer.asString(u2), "Reserved character '" + Tokenizer.asString(u2) + "' is not allowed outside quotes", true);
                }
                return Tokens.newUnquotedText(this.lineOrigin, s2);
            }
        }

        private void pullEscapeSequence(StringBuilder sb, StringBuilder sbOrig) throws ProblemException {
            int escaped = this.nextCharRaw();
            if (escaped == -1) {
                throw this.problem("End of input but backslash in string had nothing after it");
            }
            sbOrig.appendCodePoint(92);
            sbOrig.appendCodePoint(escaped);
            switch (escaped) {
                case 34: {
                    sb.append('\"');
                    break;
                }
                case 92: {
                    sb.append('\\');
                    break;
                }
                case 47: {
                    sb.append('/');
                    break;
                }
                case 98: {
                    sb.append('\b');
                    break;
                }
                case 102: {
                    sb.append('\f');
                    break;
                }
                case 110: {
                    sb.append('\n');
                    break;
                }
                case 114: {
                    sb.append('\r');
                    break;
                }
                case 116: {
                    sb.append('\t');
                    break;
                }
                case 117: {
                    char[] a2 = new char[4];
                    for (int i2 = 0; i2 < 4; ++i2) {
                        int c2 = this.nextCharRaw();
                        if (c2 == -1) {
                            throw this.problem("End of input but expecting 4 hex digits for \\uXXXX escape");
                        }
                        a2[i2] = (char)c2;
                    }
                    String digits = new String(a2);
                    sbOrig.append(a2);
                    try {
                        sb.appendCodePoint(Integer.parseInt(digits, 16));
                        break;
                    }
                    catch (NumberFormatException e2) {
                        throw this.problem(digits, String.format("Malformed hex digits after \\u escape in string: '%s'", digits), e2);
                    }
                }
                default: {
                    throw this.problem(Tokenizer.asString(escaped), String.format("backslash followed by '%s', this is not a valid escape sequence (quoted strings use JSON escaping, so use double-backslash \\\\ for literal backslash)", Tokenizer.asString(escaped)));
                }
            }
        }

        private void appendTripleQuotedString(StringBuilder sb, StringBuilder sbOrig) throws ProblemException {
            int c2;
            int consecutiveQuotes = 0;
            while (true) {
                if ((c2 = this.nextCharRaw()) == 34) {
                    ++consecutiveQuotes;
                } else {
                    if (consecutiveQuotes >= 3) break;
                    consecutiveQuotes = 0;
                    if (c2 == -1) {
                        throw this.problem("End of input but triple-quoted string was still open");
                    }
                    if (c2 == 10) {
                        ++this.lineNumber;
                        this.lineOrigin = this.origin.withLineNumber(this.lineNumber);
                    }
                }
                sb.appendCodePoint(c2);
                sbOrig.appendCodePoint(c2);
            }
            sb.setLength(sb.length() - 3);
            this.putBack(c2);
        }

        private Token pullQuotedString() throws ProblemException {
            int c2;
            StringBuilder sb = new StringBuilder();
            StringBuilder sbOrig = new StringBuilder();
            sbOrig.appendCodePoint(34);
            while (true) {
                if ((c2 = this.nextCharRaw()) == -1) {
                    throw this.problem("End of input but string quote was still open");
                }
                if (c2 == 92) {
                    this.pullEscapeSequence(sb, sbOrig);
                    continue;
                }
                if (c2 == 34) break;
                if (ConfigImplUtil.isC0Control(c2)) {
                    throw this.problem(Tokenizer.asString(c2), "JSON does not allow unescaped " + Tokenizer.asString(c2) + " in quoted strings, use a backslash escape");
                }
                sb.appendCodePoint(c2);
                sbOrig.appendCodePoint(c2);
            }
            sbOrig.appendCodePoint(c2);
            if (sb.length() == 0) {
                int third = this.nextCharRaw();
                if (third == 34) {
                    sbOrig.appendCodePoint(third);
                    this.appendTripleQuotedString(sb, sbOrig);
                } else {
                    this.putBack(third);
                }
            }
            return Tokens.newString(this.lineOrigin, sb.toString(), sbOrig.toString());
        }

        private Token pullPlusEquals() throws ProblemException {
            int c2 = this.nextCharRaw();
            if (c2 != 61) {
                throw this.problem(Tokenizer.asString(c2), "'+' not followed by =, '" + Tokenizer.asString(c2) + "' not allowed after '+'", true);
            }
            return Tokens.PLUS_EQUALS;
        }

        private Token pullSubstitution() throws ProblemException {
            Token t2;
            ConfigOrigin origin = this.lineOrigin;
            int c2 = this.nextCharRaw();
            if (c2 != 123) {
                throw this.problem(Tokenizer.asString(c2), "'$' not followed by {, '" + Tokenizer.asString(c2) + "' not allowed after '$'", true);
            }
            boolean optional = false;
            c2 = this.nextCharRaw();
            if (c2 == 63) {
                optional = true;
            } else {
                this.putBack(c2);
            }
            WhitespaceSaver saver = new WhitespaceSaver();
            ArrayList<Token> expression = new ArrayList<Token>();
            while ((t2 = this.pullNextToken(saver)) != Tokens.CLOSE_CURLY) {
                if (t2 == Tokens.END) {
                    throw TokenIterator.problem(origin, "Substitution ${ was not closed with a }");
                }
                Token whitespace = saver.check(t2, origin, this.lineNumber);
                if (whitespace != null) {
                    expression.add(whitespace);
                }
                expression.add(t2);
            }
            return Tokens.newSubstitution(origin, optional, expression);
        }

        private Token pullNextToken(WhitespaceSaver saver) throws ProblemException {
            Token t2;
            int c2 = this.nextCharAfterWhitespace(saver);
            if (c2 == -1) {
                return Tokens.END;
            }
            if (c2 == 10) {
                Token line = Tokens.newLine(this.lineOrigin);
                ++this.lineNumber;
                this.lineOrigin = this.origin.withLineNumber(this.lineNumber);
                return line;
            }
            if (this.startOfComment(c2)) {
                t2 = this.pullComment(c2);
            } else {
                switch (c2) {
                    case 34: {
                        t2 = this.pullQuotedString();
                        break;
                    }
                    case 36: {
                        t2 = this.pullSubstitution();
                        break;
                    }
                    case 58: {
                        t2 = Tokens.COLON;
                        break;
                    }
                    case 44: {
                        t2 = Tokens.COMMA;
                        break;
                    }
                    case 61: {
                        t2 = Tokens.EQUALS;
                        break;
                    }
                    case 123: {
                        t2 = Tokens.OPEN_CURLY;
                        break;
                    }
                    case 125: {
                        t2 = Tokens.CLOSE_CURLY;
                        break;
                    }
                    case 91: {
                        t2 = Tokens.OPEN_SQUARE;
                        break;
                    }
                    case 93: {
                        t2 = Tokens.CLOSE_SQUARE;
                        break;
                    }
                    case 43: {
                        t2 = this.pullPlusEquals();
                        break;
                    }
                    default: {
                        t2 = null;
                    }
                }
                if (t2 == null) {
                    if (firstNumberChars.indexOf(c2) >= 0) {
                        t2 = this.pullNumber(c2);
                    } else {
                        if (notInUnquotedText.indexOf(c2) >= 0) {
                            throw this.problem(Tokenizer.asString(c2), "Reserved character '" + Tokenizer.asString(c2) + "' is not allowed outside quotes", true);
                        }
                        this.putBack(c2);
                        t2 = this.pullUnquotedText();
                    }
                }
            }
            if (t2 == null) {
                throw new ConfigException.BugOrBroken("bug: failed to generate next token");
            }
            return t2;
        }

        private static boolean isSimpleValue(Token t2) {
            return Tokens.isSubstitution(t2) || Tokens.isUnquotedText(t2) || Tokens.isValue(t2);
        }

        private void queueNextToken() throws ProblemException {
            Token t2 = this.pullNextToken(this.whitespaceSaver);
            Token whitespace = this.whitespaceSaver.check(t2, this.origin, this.lineNumber);
            if (whitespace != null) {
                this.tokens.add(whitespace);
            }
            this.tokens.add(t2);
        }

        @Override
        public boolean hasNext() {
            return !this.tokens.isEmpty();
        }

        @Override
        public Token next() {
            Token t2 = this.tokens.remove();
            if (this.tokens.isEmpty() && t2 != Tokens.END) {
                try {
                    this.queueNextToken();
                }
                catch (ProblemException e2) {
                    this.tokens.add(e2.problem());
                }
                if (this.tokens.isEmpty()) {
                    throw new ConfigException.BugOrBroken("bug: tokens queue should not be empty here");
                }
            }
            return t2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Does not make sense to remove items from token stream");
        }

        private static class WhitespaceSaver {
            private StringBuilder whitespace = new StringBuilder();
            private boolean lastTokenWasSimpleValue = false;

            WhitespaceSaver() {
            }

            void add(int c2) {
                this.whitespace.appendCodePoint(c2);
            }

            Token check(Token t2, ConfigOrigin baseOrigin, int lineNumber) {
                if (TokenIterator.isSimpleValue(t2)) {
                    return this.nextIsASimpleValue(baseOrigin, lineNumber);
                }
                return this.nextIsNotASimpleValue(baseOrigin, lineNumber);
            }

            private Token nextIsNotASimpleValue(ConfigOrigin baseOrigin, int lineNumber) {
                this.lastTokenWasSimpleValue = false;
                return this.createWhitespaceTokenFromSaver(baseOrigin, lineNumber);
            }

            private Token nextIsASimpleValue(ConfigOrigin baseOrigin, int lineNumber) {
                Token t2 = this.createWhitespaceTokenFromSaver(baseOrigin, lineNumber);
                if (!this.lastTokenWasSimpleValue) {
                    this.lastTokenWasSimpleValue = true;
                }
                return t2;
            }

            private Token createWhitespaceTokenFromSaver(ConfigOrigin baseOrigin, int lineNumber) {
                if (this.whitespace.length() > 0) {
                    Token t2 = this.lastTokenWasSimpleValue ? Tokens.newUnquotedText(TokenIterator.lineOrigin(baseOrigin, lineNumber), this.whitespace.toString()) : Tokens.newIgnoredWhitespace(TokenIterator.lineOrigin(baseOrigin, lineNumber), this.whitespace.toString());
                    this.whitespace.setLength(0);
                    return t2;
                }
                return null;
            }
        }
    }

    private static class ProblemException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final Token problem;

        ProblemException(Token problem) {
            this.problem = problem;
        }

        Token problem() {
            return this.problem;
        }
    }
}

