/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.vocab;

import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.util.CharArrayIntMap;
import com.sun.xml.fastinfoset.util.FixedEntryStringIntMap;
import com.sun.xml.fastinfoset.util.KeyIntMap;
import com.sun.xml.fastinfoset.util.LocalNameQualifiedNamesMap;
import com.sun.xml.fastinfoset.util.StringIntMap;
import com.sun.xml.fastinfoset.vocab.Vocabulary;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class SerializerVocabulary
extends Vocabulary {
    public final StringIntMap restrictedAlphabet;
    public final StringIntMap encodingAlgorithm;
    public final StringIntMap namespaceName;
    public final StringIntMap prefix;
    public final StringIntMap localName;
    public final StringIntMap otherNCName;
    public final StringIntMap otherURI;
    public final StringIntMap attributeValue;
    public final CharArrayIntMap otherString;
    public final CharArrayIntMap characterContentChunk;
    public final LocalNameQualifiedNamesMap elementName;
    public final LocalNameQualifiedNamesMap attributeName;
    public final KeyIntMap[] tables = new KeyIntMap[12];
    protected boolean _useLocalNameAsKey;
    protected SerializerVocabulary _readOnlyVocabulary;

    public SerializerVocabulary() {
        this.restrictedAlphabet = new StringIntMap(4);
        this.tables[0] = this.restrictedAlphabet;
        this.encodingAlgorithm = new StringIntMap(4);
        this.tables[1] = this.encodingAlgorithm;
        this.prefix = new FixedEntryStringIntMap("xml", 8);
        this.tables[2] = this.prefix;
        this.namespaceName = new FixedEntryStringIntMap("http://www.w3.org/XML/1998/namespace", 8);
        this.tables[3] = this.namespaceName;
        this.localName = new StringIntMap();
        this.tables[4] = this.localName;
        this.otherNCName = new StringIntMap(4);
        this.tables[5] = this.otherNCName;
        this.otherURI = new StringIntMap(4);
        this.tables[6] = this.otherURI;
        this.attributeValue = new StringIntMap();
        this.tables[7] = this.attributeValue;
        this.otherString = new CharArrayIntMap(4);
        this.tables[8] = this.otherString;
        this.characterContentChunk = new CharArrayIntMap();
        this.tables[9] = this.characterContentChunk;
        this.elementName = new LocalNameQualifiedNamesMap();
        this.tables[10] = this.elementName;
        this.attributeName = new LocalNameQualifiedNamesMap();
        this.tables[11] = this.attributeName;
    }

    public SerializerVocabulary(org.jvnet.fastinfoset.Vocabulary v2, boolean useLocalNameAsKey) {
        this();
        this._useLocalNameAsKey = useLocalNameAsKey;
        this.convertVocabulary(v2);
    }

    public SerializerVocabulary getReadOnlyVocabulary() {
        return this._readOnlyVocabulary;
    }

    protected void setReadOnlyVocabulary(SerializerVocabulary readOnlyVocabulary, boolean clear) {
        for (int i2 = 0; i2 < this.tables.length; ++i2) {
            this.tables[i2].setReadOnlyMap(readOnlyVocabulary.tables[i2], clear);
        }
    }

    public void setInitialVocabulary(SerializerVocabulary initialVocabulary, boolean clear) {
        this.setExternalVocabularyURI(null);
        this.setInitialReadOnlyVocabulary(true);
        this.setReadOnlyVocabulary(initialVocabulary, clear);
    }

    public void setExternalVocabulary(String externalVocabularyURI, SerializerVocabulary externalVocabulary, boolean clear) {
        this.setInitialReadOnlyVocabulary(false);
        this.setExternalVocabularyURI(externalVocabularyURI);
        this.setReadOnlyVocabulary(externalVocabulary, clear);
    }

    public void clear() {
        for (int i2 = 0; i2 < this.tables.length; ++i2) {
            this.tables[i2].clear();
        }
    }

    private void convertVocabulary(org.jvnet.fastinfoset.Vocabulary v2) {
        this.addToTable(v2.restrictedAlphabets.iterator(), this.restrictedAlphabet);
        this.addToTable(v2.encodingAlgorithms.iterator(), this.encodingAlgorithm);
        this.addToTable(v2.prefixes.iterator(), this.prefix);
        this.addToTable(v2.namespaceNames.iterator(), this.namespaceName);
        this.addToTable(v2.localNames.iterator(), this.localName);
        this.addToTable(v2.otherNCNames.iterator(), this.otherNCName);
        this.addToTable(v2.otherURIs.iterator(), this.otherURI);
        this.addToTable(v2.attributeValues.iterator(), this.attributeValue);
        this.addToTable(v2.otherStrings.iterator(), this.otherString);
        this.addToTable(v2.characterContentChunks.iterator(), this.characterContentChunk);
        this.addToTable(v2.elements.iterator(), this.elementName);
        this.addToTable(v2.attributes.iterator(), this.attributeName);
    }

    private void addToTable(Iterator i2, StringIntMap m3) {
        while (i2.hasNext()) {
            this.addToTable((String)i2.next(), m3);
        }
    }

    private void addToTable(String s2, StringIntMap m3) {
        if (s2.length() == 0) {
            return;
        }
        m3.obtainIndex(s2);
    }

    private void addToTable(Iterator i2, CharArrayIntMap m3) {
        while (i2.hasNext()) {
            this.addToTable((String)i2.next(), m3);
        }
    }

    private void addToTable(String s2, CharArrayIntMap m3) {
        if (s2.length() == 0) {
            return;
        }
        char[] c2 = s2.toCharArray();
        m3.obtainIndex(c2, 0, c2.length, false);
    }

    private void addToTable(Iterator i2, LocalNameQualifiedNamesMap m3) {
        while (i2.hasNext()) {
            this.addToNameTable((QName)i2.next(), m3);
        }
    }

    private void addToNameTable(QName n2, LocalNameQualifiedNamesMap m3) {
        int localNameIndex;
        int namespaceURIIndex = -1;
        int prefixIndex = -1;
        if (n2.getNamespaceURI().length() > 0) {
            namespaceURIIndex = this.namespaceName.obtainIndex(n2.getNamespaceURI());
            if (namespaceURIIndex == -1) {
                namespaceURIIndex = this.namespaceName.get(n2.getNamespaceURI());
            }
            if (n2.getPrefix().length() > 0 && (prefixIndex = this.prefix.obtainIndex(n2.getPrefix())) == -1) {
                prefixIndex = this.prefix.get(n2.getPrefix());
            }
        }
        if ((localNameIndex = this.localName.obtainIndex(n2.getLocalPart())) == -1) {
            localNameIndex = this.localName.get(n2.getLocalPart());
        }
        QualifiedName name = new QualifiedName(n2.getPrefix(), n2.getNamespaceURI(), n2.getLocalPart(), m3.getNextIndex(), prefixIndex, namespaceURIIndex, localNameIndex);
        LocalNameQualifiedNamesMap.Entry entry = null;
        if (this._useLocalNameAsKey) {
            entry = m3.obtainEntry(n2.getLocalPart());
        } else {
            String qName = prefixIndex == -1 ? n2.getLocalPart() : n2.getPrefix() + ":" + n2.getLocalPart();
            entry = m3.obtainEntry(qName);
        }
        entry.addQualifiedName(name);
    }
}

