/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.sax;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.Encoder;
import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.util.LocalNameQualifiedNamesMap;
import java.io.IOException;
import org.jvnet.fastinfoset.FastInfosetException;
import org.jvnet.fastinfoset.sax.EncodingAlgorithmAttributes;
import org.jvnet.fastinfoset.sax.FastInfosetWriter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAXDocumentSerializer
extends Encoder
implements FastInfosetWriter {
    protected boolean _elementHasNamespaces = false;
    protected boolean _charactersAsCDATA = false;

    protected SAXDocumentSerializer(boolean v2) {
        super(v2);
    }

    public SAXDocumentSerializer() {
    }

    @Override
    public void reset() {
        super.reset();
        this._elementHasNamespaces = false;
        this._charactersAsCDATA = false;
    }

    @Override
    public final void startDocument() throws SAXException {
        try {
            this.reset();
            this.encodeHeader(false);
            this.encodeInitialVocabulary();
        }
        catch (IOException e2) {
            throw new SAXException("startDocument", e2);
        }
    }

    @Override
    public final void endDocument() throws SAXException {
        try {
            this.encodeDocumentTermination();
        }
        catch (IOException e2) {
            throw new SAXException("endDocument", e2);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            if (!this._elementHasNamespaces) {
                this.encodeTermination();
                this.mark();
                this._elementHasNamespaces = true;
                this.write(56);
            }
            this.encodeNamespaceAttribute(prefix, uri);
        }
        catch (IOException e2) {
            throw new SAXException("startElement", e2);
        }
    }

    @Override
    public final void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        int attributeCount = atts != null && atts.getLength() > 0 ? this.countAttributes(atts) : 0;
        try {
            if (this._elementHasNamespaces) {
                this._elementHasNamespaces = false;
                if (attributeCount > 0) {
                    int n2 = this._markIndex;
                    this._octetBuffer[n2] = (byte)(this._octetBuffer[n2] | 0x40);
                }
                this.resetMark();
                this.write(240);
                this._b = 0;
            } else {
                this.encodeTermination();
                this._b = 0;
                if (attributeCount > 0) {
                    this._b |= 0x40;
                }
            }
            this.encodeElement(namespaceURI, qName, localName);
            if (attributeCount > 0) {
                this.encodeAttributes(atts);
            }
        }
        catch (IOException e2) {
            throw new SAXException("startElement", e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException("startElement", e3);
        }
    }

    @Override
    public final void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.encodeElementTermination();
        }
        catch (IOException e2) {
            throw new SAXException("endElement", e2);
        }
    }

    @Override
    public final void characters(char[] ch2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        if (this.getIgnoreWhiteSpaceTextContent() && SAXDocumentSerializer.isWhiteSpace(ch2, start, length)) {
            return;
        }
        try {
            this.encodeTermination();
            if (!this._charactersAsCDATA) {
                this.encodeCharacters(ch2, start, length);
            } else {
                this.encodeCIIBuiltInAlgorithmDataAsCDATA(ch2, start, length);
            }
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public final void ignorableWhitespace(char[] ch2, int start, int length) throws SAXException {
        if (this.getIgnoreWhiteSpaceTextContent()) {
            return;
        }
        this.characters(ch2, start, length);
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
        try {
            if (this.getIgnoreProcesingInstructions()) {
                return;
            }
            if (target.length() == 0) {
                throw new SAXException(CommonResourceBundle.getInstance().getString("message.processingInstructionTargetIsEmpty"));
            }
            this.encodeTermination();
            this.encodeProcessingInstruction(target, data);
        }
        catch (IOException e2) {
            throw new SAXException("processingInstruction", e2);
        }
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    @Override
    public final void comment(char[] ch2, int start, int length) throws SAXException {
        try {
            if (this.getIgnoreComments()) {
                return;
            }
            this.encodeTermination();
            this.encodeComment(ch2, start, length);
        }
        catch (IOException e2) {
            throw new SAXException("startElement", e2);
        }
    }

    @Override
    public final void startCDATA() throws SAXException {
        this._charactersAsCDATA = true;
    }

    @Override
    public final void endCDATA() throws SAXException {
        this._charactersAsCDATA = false;
    }

    @Override
    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.getIgnoreDTD()) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeDocumentTypeDeclaration(publicId, systemId);
            this.encodeElementTermination();
        }
        catch (IOException e2) {
            throw new SAXException("startDTD", e2);
        }
    }

    @Override
    public final void endDTD() throws SAXException {
    }

    @Override
    public final void startEntity(String name) throws SAXException {
    }

    @Override
    public final void endEntity(String name) throws SAXException {
    }

    @Override
    public final void octets(String URI2, int id2, byte[] b2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeNonIdentifyingStringOnThirdBit(URI2, id2, b2, start, length);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public final void object(String URI2, int id2, Object data) throws SAXException {
        try {
            this.encodeTermination();
            this.encodeNonIdentifyingStringOnThirdBit(URI2, id2, data);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public final void bytes(byte[] b2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIOctetAlgorithmData(1, b2, start, length);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
    }

    @Override
    public final void shorts(short[] s2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(2, s2, start, length);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public final void ints(int[] i2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(3, i2, start, length);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public final void longs(long[] l2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(4, l2, start, length);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public final void booleans(boolean[] b2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(5, b2, start, length);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public final void floats(float[] f2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(6, f2, start, length);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public final void doubles(double[] d2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(7, d2, start, length);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public void uuids(long[] msblsb, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            this.encodeCIIBuiltInAlgorithmData(8, msblsb, start, length);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public void numericCharacters(char[] ch2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            boolean addToTable = this.isCharacterContentChunkLengthMatchesLimit(length);
            this.encodeNumericFourBitCharacters(ch2, start, length, addToTable);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public void dateTimeCharacters(char[] ch2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            boolean addToTable = this.isCharacterContentChunkLengthMatchesLimit(length);
            this.encodeDateTimeFourBitCharacters(ch2, start, length, addToTable);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public void alphabetCharacters(String alphabet, char[] ch2, int start, int length) throws SAXException {
        if (length <= 0) {
            return;
        }
        try {
            this.encodeTermination();
            boolean addToTable = this.isCharacterContentChunkLengthMatchesLimit(length);
            this.encodeAlphabetCharacters(alphabet, ch2, start, length, addToTable);
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    @Override
    public void characters(char[] ch2, int start, int length, boolean index) throws SAXException {
        if (length <= 0) {
            return;
        }
        if (this.getIgnoreWhiteSpaceTextContent() && SAXDocumentSerializer.isWhiteSpace(ch2, start, length)) {
            return;
        }
        try {
            this.encodeTermination();
            if (!this._charactersAsCDATA) {
                this.encodeNonIdentifyingStringOnThirdBit(ch2, start, length, this._v.characterContentChunk, index, true);
            } else {
                this.encodeCIIBuiltInAlgorithmDataAsCDATA(ch2, start, length);
            }
        }
        catch (IOException e2) {
            throw new SAXException(e2);
        }
        catch (FastInfosetException e3) {
            throw new SAXException(e3);
        }
    }

    protected final int countAttributes(Attributes atts) {
        int count = 0;
        for (int i2 = 0; i2 < atts.getLength(); ++i2) {
            String uri = atts.getURI(i2);
            if (uri == "http://www.w3.org/2000/xmlns/" || uri.equals("http://www.w3.org/2000/xmlns/")) continue;
            ++count;
        }
        return count;
    }

    protected void encodeAttributes(Attributes atts) throws IOException, FastInfosetException {
        if (atts instanceof EncodingAlgorithmAttributes) {
            EncodingAlgorithmAttributes eAtts = (EncodingAlgorithmAttributes)atts;
            for (int i2 = 0; i2 < eAtts.getLength(); ++i2) {
                if (!this.encodeAttribute(atts.getURI(i2), atts.getQName(i2), atts.getLocalName(i2))) continue;
                Object data = eAtts.getAlgorithmData(i2);
                if (data == null) {
                    String value = eAtts.getValue(i2);
                    boolean addToTable = this.isAttributeValueLengthMatchesLimit(value.length());
                    boolean mustBeAddedToTable = eAtts.getToIndex(i2);
                    String alphabet = eAtts.getAlpababet(i2);
                    if (alphabet == null) {
                        this.encodeNonIdentifyingStringOnFirstBit(value, this._v.attributeValue, addToTable, mustBeAddedToTable);
                        continue;
                    }
                    if (alphabet == "0123456789-:TZ ") {
                        this.encodeDateTimeNonIdentifyingStringOnFirstBit(value, addToTable, mustBeAddedToTable);
                        continue;
                    }
                    if (alphabet == "0123456789-+.E ") {
                        this.encodeNumericNonIdentifyingStringOnFirstBit(value, addToTable, mustBeAddedToTable);
                        continue;
                    }
                    this.encodeNonIdentifyingStringOnFirstBit(value, this._v.attributeValue, addToTable, mustBeAddedToTable);
                    continue;
                }
                this.encodeNonIdentifyingStringOnFirstBit(eAtts.getAlgorithmURI(i2), eAtts.getAlgorithmIndex(i2), data);
            }
        } else {
            for (int i3 = 0; i3 < atts.getLength(); ++i3) {
                if (!this.encodeAttribute(atts.getURI(i3), atts.getQName(i3), atts.getLocalName(i3))) continue;
                String value = atts.getValue(i3);
                boolean addToTable = this.isAttributeValueLengthMatchesLimit(value.length());
                this.encodeNonIdentifyingStringOnFirstBit(value, this._v.attributeValue, addToTable, false);
            }
        }
        this._b = 240;
        this._terminate = true;
    }

    protected void encodeElement(String namespaceURI, String qName, String localName) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.elementName.obtainEntry(qName);
        if (entry._valueIndex > 0) {
            QualifiedName[] names = entry._value;
            for (int i2 = 0; i2 < entry._valueIndex; ++i2) {
                QualifiedName n2 = names[i2];
                if (namespaceURI != n2.namespaceName && !namespaceURI.equals(n2.namespaceName)) continue;
                this.encodeNonZeroIntegerOnThirdBit(names[i2].index);
                return;
            }
        }
        this.encodeLiteralElementQualifiedNameOnThirdBit(namespaceURI, SAXDocumentSerializer.getPrefixFromQualifiedName(qName), localName, entry);
    }

    protected boolean encodeAttribute(String namespaceURI, String qName, String localName) throws IOException {
        LocalNameQualifiedNamesMap.Entry entry = this._v.attributeName.obtainEntry(qName);
        if (entry._valueIndex > 0) {
            QualifiedName[] names = entry._value;
            for (int i2 = 0; i2 < entry._valueIndex; ++i2) {
                if (namespaceURI != names[i2].namespaceName && !namespaceURI.equals(names[i2].namespaceName)) continue;
                this.encodeNonZeroIntegerOnSecondBitFirstBitZero(names[i2].index);
                return true;
            }
        }
        return this.encodeLiteralAttributeQualifiedNameOnSecondBit(namespaceURI, SAXDocumentSerializer.getPrefixFromQualifiedName(qName), localName, entry);
    }
}

