/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.algorithm;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.fastinfoset.algorithm.IntegerEncodingAlgorithm;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.fastinfoset.EncodingAlgorithmException;

public class IntEncodingAlgorithm
extends IntegerEncodingAlgorithm {
    @Override
    public final int getPrimtiveLengthFromOctetLength(int octetLength) throws EncodingAlgorithmException {
        if (octetLength % 4 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfInt", new Object[]{4}));
        }
        return octetLength / 4;
    }

    @Override
    public int getOctetLengthFromPrimitiveLength(int primitiveLength) {
        return primitiveLength * 4;
    }

    @Override
    public final Object decodeFromBytes(byte[] b2, int start, int length) throws EncodingAlgorithmException {
        int[] data = new int[this.getPrimtiveLengthFromOctetLength(length)];
        this.decodeFromBytesToIntArray(data, 0, b2, start, length);
        return data;
    }

    @Override
    public final Object decodeFromInputStream(InputStream s2) throws IOException {
        return this.decodeFromInputStreamToIntArray(s2);
    }

    @Override
    public void encodeToOutputStream(Object data, OutputStream s2) throws IOException {
        if (!(data instanceof int[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotIntArray"));
        }
        int[] idata = (int[])data;
        this.encodeToOutputStreamFromIntArray(idata, s2);
    }

    @Override
    public final Object convertFromCharacters(char[] ch2, int start, int length) {
        final CharBuffer cb2 = CharBuffer.wrap(ch2, start, length);
        final ArrayList integerList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(cb2, new BuiltInEncodingAlgorithm.WordListener(){

            @Override
            public void word(int start, int end) {
                String iStringValue = cb2.subSequence(start, end).toString();
                integerList.add(Integer.valueOf(iStringValue));
            }
        });
        return this.generateArrayFromList(integerList);
    }

    @Override
    public final void convertToCharacters(Object data, StringBuffer s2) {
        if (!(data instanceof int[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotIntArray"));
        }
        int[] idata = (int[])data;
        this.convertToCharactersFromIntArray(idata, s2);
    }

    public final void decodeFromBytesToIntArray(int[] idata, int istart, byte[] b2, int start, int length) {
        int size = length / 4;
        for (int i2 = 0; i2 < size; ++i2) {
            idata[istart++] = (b2[start++] & 0xFF) << 24 | (b2[start++] & 0xFF) << 16 | (b2[start++] & 0xFF) << 8 | b2[start++] & 0xFF;
        }
    }

    public final int[] decodeFromInputStreamToIntArray(InputStream s2) throws IOException {
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        byte[] b2 = new byte[4];
        while (true) {
            int n2;
            if ((n2 = s2.read(b2)) != 4) {
                if (n2 == -1) break;
                while (n2 != 4) {
                    int m3 = s2.read(b2, n2, 4 - n2);
                    if (m3 == -1) {
                        throw new EOFException();
                    }
                    n2 += m3;
                }
            }
            int i2 = (b2[0] & 0xFF) << 24 | (b2[1] & 0xFF) << 16 | (b2[2] & 0xFF) << 8 | b2[3] & 0xFF;
            integerList.add(i2);
        }
        return this.generateArrayFromList(integerList);
    }

    public final void encodeToOutputStreamFromIntArray(int[] idata, OutputStream s2) throws IOException {
        for (int i2 = 0; i2 < idata.length; ++i2) {
            int bits = idata[i2];
            s2.write(bits >>> 24 & 0xFF);
            s2.write(bits >>> 16 & 0xFF);
            s2.write(bits >>> 8 & 0xFF);
            s2.write(bits & 0xFF);
        }
    }

    @Override
    public final void encodeToBytes(Object array, int astart, int alength, byte[] b2, int start) {
        this.encodeToBytesFromIntArray((int[])array, astart, alength, b2, start);
    }

    public final void encodeToBytesFromIntArray(int[] idata, int istart, int ilength, byte[] b2, int start) {
        int iend = istart + ilength;
        for (int i2 = istart; i2 < iend; ++i2) {
            int bits = idata[i2];
            b2[start++] = (byte)(bits >>> 24 & 0xFF);
            b2[start++] = (byte)(bits >>> 16 & 0xFF);
            b2[start++] = (byte)(bits >>> 8 & 0xFF);
            b2[start++] = (byte)(bits & 0xFF);
        }
    }

    public final void convertToCharactersFromIntArray(int[] idata, StringBuffer s2) {
        int end = idata.length - 1;
        for (int i2 = 0; i2 <= end; ++i2) {
            s2.append(Integer.toString(idata[i2]));
            if (i2 == end) continue;
            s2.append(' ');
        }
    }

    public final int[] generateArrayFromList(List array) {
        int[] idata = new int[array.size()];
        for (int i2 = 0; i2 < idata.length; ++i2) {
            idata[i2] = (Integer)array.get(i2);
        }
        return idata;
    }
}

