/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.util;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.WeakHashMap;

public class EditDistance {
    private static final WeakHashMap<AbstractMap.SimpleEntry<String, String>, Integer> CACHE = new WeakHashMap();
    private int[] cost;
    private int[] back;
    private final String a;
    private final String b;

    public static int editDistance(String a2, String b2) {
        AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(a2, b2);
        Integer result = null;
        if (CACHE.containsKey(entry)) {
            result = CACHE.get(entry);
        }
        if (result == null) {
            result = new EditDistance(a2, b2).calc();
            CACHE.put(entry, result);
        }
        return result;
    }

    public static String findNearest(String key, String[] group) {
        return EditDistance.findNearest(key, Arrays.asList(group));
    }

    public static String findNearest(String key, Collection<String> group) {
        int c2 = Integer.MAX_VALUE;
        String r2 = null;
        for (String s2 : group) {
            int ed2 = EditDistance.editDistance(key, s2);
            if (c2 <= ed2) continue;
            c2 = ed2;
            r2 = s2;
        }
        return r2;
    }

    private EditDistance(String a2, String b2) {
        this.a = a2;
        this.b = b2;
        this.cost = new int[a2.length() + 1];
        this.back = new int[a2.length() + 1];
        for (int i2 = 0; i2 <= a2.length(); ++i2) {
            this.cost[i2] = i2;
        }
    }

    private void flip() {
        int[] t2 = this.cost;
        this.cost = this.back;
        this.back = t2;
    }

    private int min(int a2, int b2, int c2) {
        return Math.min(a2, Math.min(b2, c2));
    }

    private int calc() {
        for (int j2 = 0; j2 < this.b.length(); ++j2) {
            this.flip();
            this.cost[0] = j2 + 1;
            for (int i2 = 0; i2 < this.a.length(); ++i2) {
                int match = this.a.charAt(i2) == this.b.charAt(j2) ? 0 : 1;
                this.cost[i2 + 1] = this.min(this.back[i2] + match, this.cost[i2] + 1, this.back[i2 + 1] + 1);
            }
        }
        return this.cost[this.a.length()];
    }
}

