/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.model.annotation;

import com.sun.xml.bind.v2.model.annotation.AbstractInlineAnnotationReaderImpl;
import com.sun.xml.bind.v2.model.annotation.Locatable;
import com.sun.xml.bind.v2.model.annotation.LocatableAnnotation;
import com.sun.xml.bind.v2.model.annotation.Messages;
import com.sun.xml.bind.v2.model.annotation.RuntimeAnnotationReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public final class RuntimeInlineAnnotationReader
extends AbstractInlineAnnotationReaderImpl<Type, Class, Field, Method>
implements RuntimeAnnotationReader {
    private final Map<Class<? extends Annotation>, Map<Package, Annotation>> packageCache = new HashMap<Class<? extends Annotation>, Map<Package, Annotation>>();

    @Override
    public <A extends Annotation> A getFieldAnnotation(Class<A> annotation, Field field, Locatable srcPos) {
        return LocatableAnnotation.create(field.getAnnotation(annotation), srcPos);
    }

    @Override
    public boolean hasFieldAnnotation(Class<? extends Annotation> annotationType, Field field) {
        return field.isAnnotationPresent(annotationType);
    }

    @Override
    public boolean hasClassAnnotation(Class clazz, Class<? extends Annotation> annotationType) {
        return clazz.isAnnotationPresent(annotationType);
    }

    @Override
    public Annotation[] getAllFieldAnnotations(Field field, Locatable srcPos) {
        Annotation[] r2 = field.getAnnotations();
        for (int i2 = 0; i2 < r2.length; ++i2) {
            r2[i2] = LocatableAnnotation.create(r2[i2], srcPos);
        }
        return r2;
    }

    @Override
    public <A extends Annotation> A getMethodAnnotation(Class<A> annotation, Method method, Locatable srcPos) {
        return LocatableAnnotation.create(method.getAnnotation(annotation), srcPos);
    }

    @Override
    public boolean hasMethodAnnotation(Class<? extends Annotation> annotation, Method method) {
        return method.isAnnotationPresent(annotation);
    }

    @Override
    public Annotation[] getAllMethodAnnotations(Method method, Locatable srcPos) {
        Annotation[] r2 = method.getAnnotations();
        for (int i2 = 0; i2 < r2.length; ++i2) {
            r2[i2] = LocatableAnnotation.create(r2[i2], srcPos);
        }
        return r2;
    }

    @Override
    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> annotation, Method method, int paramIndex, Locatable srcPos) {
        Annotation[] pa;
        for (Annotation a2 : pa = method.getParameterAnnotations()[paramIndex]) {
            if (a2.annotationType() != annotation) continue;
            return (A)LocatableAnnotation.create(a2, srcPos);
        }
        return null;
    }

    @Override
    public <A extends Annotation> A getClassAnnotation(Class<A> a2, Class clazz, Locatable srcPos) {
        return LocatableAnnotation.create(clazz.getAnnotation(a2), srcPos);
    }

    @Override
    public <A extends Annotation> A getPackageAnnotation(Class<A> a2, Class clazz, Locatable srcPos) {
        Package p2 = clazz.getPackage();
        if (p2 == null) {
            return null;
        }
        Map<Package, Annotation> cache = this.packageCache.get(a2);
        if (cache == null) {
            cache = new HashMap<Package, Annotation>();
            this.packageCache.put(a2, cache);
        }
        if (cache.containsKey(p2)) {
            return (A)cache.get(p2);
        }
        A ann = LocatableAnnotation.create(p2.getAnnotation(a2), srcPos);
        cache.put(p2, (Annotation)ann);
        return ann;
    }

    @Override
    public Class getClassValue(Annotation a2, String name) {
        try {
            return (Class)a2.annotationType().getMethod(name, new Class[0]).invoke((Object)a2, new Object[0]);
        }
        catch (IllegalAccessException e2) {
            throw new IllegalAccessError(e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            throw new InternalError(Messages.CLASS_NOT_FOUND.format(a2.annotationType(), e3.getMessage()));
        }
        catch (NoSuchMethodException e4) {
            throw new NoSuchMethodError(e4.getMessage());
        }
    }

    public Class[] getClassArrayValue(Annotation a2, String name) {
        try {
            return (Class[])a2.annotationType().getMethod(name, new Class[0]).invoke((Object)a2, new Object[0]);
        }
        catch (IllegalAccessException e2) {
            throw new IllegalAccessError(e2.getMessage());
        }
        catch (InvocationTargetException e3) {
            throw new InternalError(e3.getMessage());
        }
        catch (NoSuchMethodException e4) {
            throw new NoSuchMethodError(e4.getMessage());
        }
    }

    @Override
    protected String fullName(Method m3) {
        return m3.getDeclaringClass().getName() + '#' + m3.getName();
    }
}

