/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.marshaller;

import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import java.io.IOException;
import java.io.Writer;

public class MinimumEscapeHandler
implements CharacterEscapeHandler {
    public static final CharacterEscapeHandler theInstance = new MinimumEscapeHandler();

    private MinimumEscapeHandler() {
    }

    @Override
    public void escape(char[] ch2, int start, int length, boolean isAttVal, Writer out) throws IOException {
        int limit = start + length;
        block7: for (int i2 = start; i2 < limit; ++i2) {
            char c2 = ch2[i2];
            if (c2 != '&' && c2 != '<' && c2 != '>' && c2 != '\r' && (c2 != '\n' || !isAttVal) && (c2 != '\"' || !isAttVal)) continue;
            if (i2 != start) {
                out.write(ch2, start, i2 - start);
            }
            start = i2 + 1;
            switch (ch2[i2]) {
                case '&': {
                    out.write("&amp;");
                    continue block7;
                }
                case '<': {
                    out.write("&lt;");
                    continue block7;
                }
                case '>': {
                    out.write("&gt;");
                    continue block7;
                }
                case '\"': {
                    out.write("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    out.write("&#");
                    out.write(Integer.toString(c2));
                    out.write(59);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Cannot escape: '" + c2 + "'");
                }
            }
        }
        if (start != limit) {
            out.write(ch2, start, limit - start);
        }
    }
}

