/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util.logging;

import com.sun.mail.util.logging.CompactFormatter;
import com.sun.mail.util.logging.LogManagerProperties;
import com.sun.mail.util.logging.SeverityComparator;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class CollectorFormatter
extends Formatter {
    private static final long INIT_TIME = System.currentTimeMillis();
    private final String fmt;
    private final Formatter formatter;
    private final Comparator<? super LogRecord> comparator;
    private LogRecord last;
    private long count;
    private long generation = 1L;
    private long thrown;
    private long minMillis = INIT_TIME;
    private long maxMillis = Long.MIN_VALUE;

    public CollectorFormatter() {
        String p2 = this.getClass().getName();
        this.fmt = this.initFormat(p2);
        this.formatter = this.initFormatter(p2);
        this.comparator = this.initComparator(p2);
    }

    public CollectorFormatter(String format) {
        String p2 = this.getClass().getName();
        this.fmt = format == null ? this.initFormat(p2) : format;
        this.formatter = this.initFormatter(p2);
        this.comparator = this.initComparator(p2);
    }

    public CollectorFormatter(String format, Formatter f2, Comparator<? super LogRecord> c2) {
        String p2 = this.getClass().getName();
        this.fmt = format == null ? this.initFormat(p2) : format;
        this.formatter = f2;
        this.comparator = c2;
    }

    @Override
    public String format(LogRecord record) {
        boolean accepted;
        if (record == null) {
            throw new NullPointerException();
        }
        do {
            LogRecord update;
            LogRecord peek;
            if (peek != (update = this.apply((peek = this.peek()) != null ? peek : record, record))) {
                update.getSourceMethodName();
                accepted = this.acceptAndUpdate(peek, update);
                continue;
            }
            accepted = this.accept(peek, record);
        } while (!accepted);
        return "";
    }

    @Override
    public String getTail(Handler h2) {
        super.getTail(h2);
        return this.formatRecord(h2, true);
    }

    public String toString() {
        String result;
        try {
            result = this.formatRecord(null, false);
        }
        catch (RuntimeException ignore) {
            result = super.toString();
        }
        return result;
    }

    protected LogRecord apply(LogRecord t2, LogRecord u2) {
        if (t2 == null || u2 == null) {
            throw new NullPointerException();
        }
        if (this.comparator != null) {
            return this.comparator.compare(t2, u2) >= 0 ? t2 : u2;
        }
        return u2;
    }

    private synchronized boolean accept(LogRecord e2, LogRecord u2) {
        long millis = u2.getMillis();
        Throwable ex2 = u2.getThrown();
        if (this.last == e2) {
            this.minMillis = ++this.count != 1L ? Math.min(this.minMillis, millis) : millis;
            this.maxMillis = Math.max(this.maxMillis, millis);
            if (ex2 != null) {
                ++this.thrown;
            }
            return true;
        }
        return false;
    }

    private synchronized void reset(long min2) {
        if (this.last != null) {
            this.last = null;
            ++this.generation;
        }
        this.count = 0L;
        this.thrown = 0L;
        this.minMillis = min2;
        this.maxMillis = Long.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatRecord(Handler h2, boolean reset) {
        String tail;
        String msg;
        String head;
        long now;
        long msh;
        long msl;
        long t2;
        long g2;
        long c2;
        LogRecord record;
        CollectorFormatter collectorFormatter = this;
        synchronized (collectorFormatter) {
            record = this.last;
            c2 = this.count;
            g2 = this.generation;
            t2 = this.thrown;
            msl = this.minMillis;
            msh = this.maxMillis;
            now = System.currentTimeMillis();
            if (c2 == 0L) {
                msh = now;
            }
            if (reset) {
                this.reset(msh);
            }
        }
        Formatter f2 = this.formatter;
        if (f2 != null) {
            Formatter formatter = f2;
            synchronized (formatter) {
                head = f2.getHead(h2);
                msg = record != null ? f2.format(record) : "";
                tail = f2.getTail(h2);
            }
        } else {
            head = "";
            msg = record != null ? this.formatMessage(record) : "";
            tail = "";
        }
        Locale l2 = null;
        if (record != null) {
            ResourceBundle rb = record.getResourceBundle();
            l2 = rb == null ? null : rb.getLocale();
        }
        MessageFormat mf = l2 == null ? new MessageFormat(this.fmt) : new MessageFormat(this.fmt, l2);
        return mf.format(new Object[]{this.finish(head), this.finish(msg), this.finish(tail), c2, c2 - 1L, t2, c2 - t2, msl, msh, msh - msl, INIT_TIME, now, now - INIT_TIME, g2});
    }

    protected String finish(String s2) {
        return s2.trim();
    }

    private synchronized LogRecord peek() {
        return this.last;
    }

    private synchronized boolean acceptAndUpdate(LogRecord e2, LogRecord u2) {
        if (this.accept(e2, u2)) {
            this.last = u2;
            return true;
        }
        return false;
    }

    private String initFormat(String p2) {
        String v2 = LogManagerProperties.fromLogManager(p2.concat(".format"));
        if (v2 == null || v2.length() == 0) {
            v2 = "{0}{1}{2}{4,choice,-1#|0#|0<... {4,number,integer} more}\n";
        }
        return v2;
    }

    private Formatter initFormatter(String p2) {
        Formatter f2;
        String v2 = LogManagerProperties.fromLogManager(p2.concat(".formatter"));
        if (v2 != null && v2.length() != 0) {
            if (!"null".equalsIgnoreCase(v2)) {
                try {
                    f2 = LogManagerProperties.newFormatter(v2);
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e2) {
                    throw new UndeclaredThrowableException(e2);
                }
            } else {
                f2 = null;
            }
        } else {
            f2 = (Formatter)Formatter.class.cast(new CompactFormatter());
        }
        return f2;
    }

    private Comparator<? super LogRecord> initComparator(String p2) {
        Comparator<? super LogRecord> c2;
        String name = LogManagerProperties.fromLogManager(p2.concat(".comparator"));
        String reverse = LogManagerProperties.fromLogManager(p2.concat(".comparator.reverse"));
        try {
            if (name != null && name.length() != 0) {
                if (!"null".equalsIgnoreCase(name)) {
                    c2 = LogManagerProperties.newComparator(name);
                    if (Boolean.parseBoolean(reverse)) {
                        assert (c2 != null);
                        c2 = LogManagerProperties.reverseOrder(c2);
                    }
                } else {
                    if (reverse != null) {
                        throw new IllegalArgumentException("No comparator to reverse.");
                    }
                    c2 = null;
                }
            } else {
                if (reverse != null) {
                    throw new IllegalArgumentException("No comparator to reverse.");
                }
                c2 = (Comparator<? super LogRecord>)Comparator.class.cast(SeverityComparator.getInstance());
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e2) {
            throw new UndeclaredThrowableException(e2);
        }
        return c2;
    }
}

