/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import com.sun.mail.util.MailLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;

public class LogOutputStream
extends OutputStream {
    protected MailLogger logger;
    protected Level level;
    private int lastb = -1;
    private byte[] buf = new byte[80];
    private int pos = 0;

    public LogOutputStream(MailLogger logger) {
        this.logger = logger;
        this.level = Level.FINEST;
    }

    @Override
    public void write(int b2) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        if (b2 == 13) {
            this.logBuf();
        } else if (b2 == 10) {
            if (this.lastb != 13) {
                this.logBuf();
            }
        } else {
            this.expandCapacity(1);
            this.buf[this.pos++] = (byte)b2;
        }
        this.lastb = b2;
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        int start = off;
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        len += off;
        for (int i2 = start; i2 < len; ++i2) {
            if (b2[i2] == 13) {
                this.expandCapacity(i2 - start);
                System.arraycopy(b2, start, this.buf, this.pos, i2 - start);
                this.pos += i2 - start;
                this.logBuf();
                start = i2 + 1;
            } else if (b2[i2] == 10) {
                if (this.lastb != 13) {
                    this.expandCapacity(i2 - start);
                    System.arraycopy(b2, start, this.buf, this.pos, i2 - start);
                    this.pos += i2 - start;
                    this.logBuf();
                }
                start = i2 + 1;
            }
            this.lastb = b2[i2];
        }
        if (len - start > 0) {
            this.expandCapacity(len - start);
            System.arraycopy(b2, start, this.buf, this.pos, len - start);
            this.pos += len - start;
        }
    }

    protected void log(String msg) {
        this.logger.log(this.level, msg);
    }

    private void logBuf() {
        String msg = new String(this.buf, 0, this.pos);
        this.pos = 0;
        this.log(msg);
    }

    private void expandCapacity(int len) {
        while (this.pos + len > this.buf.length) {
            byte[] nb = new byte[this.buf.length * 2];
            System.arraycopy(this.buf, 0, nb, 0, this.pos);
            this.buf = nb;
        }
    }
}

