/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.auth.OAuth2SaslClientFactory;
import com.sun.mail.iap.Argument;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.SaslAuthenticator;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.MailLogger;
import com.sun.mail.util.PropUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class IMAPSaslAuthenticator
implements SaslAuthenticator {
    private IMAPProtocol pr;
    private String name;
    private Properties props;
    private MailLogger logger;
    private String host;

    public IMAPSaslAuthenticator(IMAPProtocol pr, String name, Properties props, MailLogger logger, String host) {
        this.pr = pr;
        this.name = name;
        this.props = props;
        this.logger = logger;
        this.host = host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(String[] mechs, final String realm, String authzid, final String u2, final String p2) throws ProtocolException {
        IMAPProtocol iMAPProtocol = this.pr;
        synchronized (iMAPProtocol) {
            String qop;
            boolean isXGWTRUSTEDAPP;
            SaslClient sc;
            ArrayList<Response> v2 = new ArrayList<Response>();
            String tag = null;
            Response r2 = null;
            boolean done = false;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("SASL Mechanisms:");
                for (int i2 = 0; i2 < mechs.length; ++i2) {
                    this.logger.fine(" " + mechs[i2]);
                }
                this.logger.fine("");
            }
            CallbackHandler cbh = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) {
                    if (IMAPSaslAuthenticator.this.logger.isLoggable(Level.FINE)) {
                        IMAPSaslAuthenticator.this.logger.fine("SASL callback length: " + callbacks.length);
                    }
                    block0: for (int i2 = 0; i2 < callbacks.length; ++i2) {
                        Callback rcb;
                        if (IMAPSaslAuthenticator.this.logger.isLoggable(Level.FINE)) {
                            IMAPSaslAuthenticator.this.logger.fine("SASL callback " + i2 + ": " + callbacks[i2]);
                        }
                        if (callbacks[i2] instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)callbacks[i2];
                            ncb.setName(u2);
                            continue;
                        }
                        if (callbacks[i2] instanceof PasswordCallback) {
                            PasswordCallback pcb = (PasswordCallback)callbacks[i2];
                            pcb.setPassword(p2.toCharArray());
                            continue;
                        }
                        if (callbacks[i2] instanceof RealmCallback) {
                            rcb = (RealmCallback)callbacks[i2];
                            ((TextInputCallback)rcb).setText(realm != null ? realm : ((TextInputCallback)rcb).getDefaultText());
                            continue;
                        }
                        if (!(callbacks[i2] instanceof RealmChoiceCallback)) continue;
                        rcb = (RealmChoiceCallback)callbacks[i2];
                        if (realm == null) {
                            ((ChoiceCallback)rcb).setSelectedIndex(((ChoiceCallback)rcb).getDefaultChoice());
                            continue;
                        }
                        String[] choices = ((ChoiceCallback)rcb).getChoices();
                        for (int k2 = 0; k2 < choices.length; ++k2) {
                            if (!choices[k2].equals(realm)) continue;
                            ((ChoiceCallback)rcb).setSelectedIndex(k2);
                            continue block0;
                        }
                    }
                }
            };
            try {
                Properties propsMap = this.props;
                sc = Sasl.createSaslClient(mechs, authzid, this.name, this.host, propsMap, cbh);
            }
            catch (SaslException sex) {
                this.logger.log(Level.FINE, "Failed to create SASL client", sex);
                throw new UnsupportedOperationException(sex.getMessage(), sex);
            }
            if (sc == null) {
                this.logger.fine("No SASL support");
                throw new UnsupportedOperationException("No SASL support");
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("SASL client " + sc.getMechanismName());
            }
            try {
                Argument args2 = new Argument();
                args2.writeAtom(sc.getMechanismName());
                if (this.pr.hasCapability("SASL-IR") && sc.hasInitialResponse()) {
                    String irs;
                    byte[] ba2 = sc.evaluateChallenge(new byte[0]);
                    if (ba2.length > 0) {
                        ba2 = BASE64EncoderStream.encode(ba2);
                        irs = ASCIIUtility.toString(ba2, 0, ba2.length);
                    } else {
                        irs = "=";
                    }
                    args2.writeAtom(irs);
                }
                tag = this.pr.writeCommand("AUTHENTICATE", args2);
            }
            catch (Exception ex2) {
                this.logger.log(Level.FINE, "SASL AUTHENTICATE Exception", ex2);
                return false;
            }
            OutputStream os = this.pr.getIMAPOutputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] CRLF = new byte[]{13, 10};
            boolean bl2 = isXGWTRUSTEDAPP = sc.getMechanismName().equals("XGWTRUSTEDAPP") && PropUtil.getBooleanProperty(this.props, "mail." + this.name + ".sasl.xgwtrustedapphack.enable", true);
            while (!done) {
                try {
                    r2 = this.pr.readResponse();
                    if (r2.isContinuation()) {
                        byte[] ba3 = null;
                        if (!sc.isComplete()) {
                            ba3 = r2.readByteArray().getNewBytes();
                            if (ba3.length > 0) {
                                ba3 = BASE64DecoderStream.decode(ba3);
                            }
                            if (this.logger.isLoggable(Level.FINE)) {
                                this.logger.fine("SASL challenge: " + ASCIIUtility.toString(ba3, 0, ba3.length) + " :");
                            }
                            ba3 = sc.evaluateChallenge(ba3);
                        }
                        if (ba3 == null) {
                            this.logger.fine("SASL no response");
                            os.write(CRLF);
                            os.flush();
                            bos.reset();
                            continue;
                        }
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("SASL response: " + ASCIIUtility.toString(ba3, 0, ba3.length) + " :");
                        }
                        ba3 = BASE64EncoderStream.encode(ba3);
                        if (isXGWTRUSTEDAPP) {
                            bos.write(ASCIIUtility.getBytes("XGWTRUSTEDAPP "));
                        }
                        bos.write(ba3);
                        bos.write(CRLF);
                        os.write(bos.toByteArray());
                        os.flush();
                        bos.reset();
                        continue;
                    }
                    if (r2.isTagged() && r2.getTag().equals(tag)) {
                        done = true;
                        continue;
                    }
                    if (r2.isBYE()) {
                        done = true;
                        continue;
                    }
                    v2.add(r2);
                }
                catch (Exception ioex) {
                    this.logger.log(Level.FINE, "SASL Exception", ioex);
                    r2 = Response.byeResponse(ioex);
                    done = true;
                }
            }
            if (sc.isComplete() && (qop = (String)sc.getNegotiatedProperty("javax.security.sasl.qop")) != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
                this.logger.fine("SASL Mechanism requires integrity or confidentiality");
                return false;
            }
            Response[] responses = v2.toArray(new Response[v2.size()]);
            this.pr.handleCapabilityResponse(responses);
            this.pr.notifyResponseHandlers(responses);
            this.pr.handleLoginResult(r2);
            this.pr.setCapabilities(r2);
            if (isXGWTRUSTEDAPP && authzid != null) {
                Argument args3 = new Argument();
                args3.writeString(authzid);
                responses = this.pr.command("LOGIN", args3);
                this.pr.notifyResponseHandlers(responses);
                this.pr.handleResult(responses[responses.length - 1]);
                this.pr.setCapabilities(responses[responses.length - 1]);
            }
            return true;
        }
    }

    static {
        try {
            OAuth2SaslClientFactory.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

