/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPAddress;
import com.sun.mail.imap.protocol.Item;
import com.sun.mail.util.PropUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;

public class ENVELOPE
implements Item {
    static final char[] name = new char[]{'E', 'N', 'V', 'E', 'L', 'O', 'P', 'E'};
    public int msgno;
    public Date date = null;
    public String subject;
    public InternetAddress[] from;
    public InternetAddress[] sender;
    public InternetAddress[] replyTo;
    public InternetAddress[] to;
    public InternetAddress[] cc;
    public InternetAddress[] bcc;
    public String inReplyTo;
    public String messageId;
    private static final MailDateFormat mailDateFormat = new MailDateFormat();
    private static final boolean parseDebug = PropUtil.getBooleanSystemProperty("mail.imap.parse.debug", false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ENVELOPE(FetchResponse r2) throws ParsingException {
        if (parseDebug) {
            System.out.println("parse ENVELOPE");
        }
        this.msgno = r2.getNumber();
        r2.skipSpaces();
        if (r2.readByte() != 40) {
            throw new ParsingException("ENVELOPE parse error");
        }
        String s2 = r2.readString();
        if (s2 != null) {
            try {
                MailDateFormat mailDateFormat = ENVELOPE.mailDateFormat;
                synchronized (mailDateFormat) {
                    this.date = ENVELOPE.mailDateFormat.parse(s2);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (parseDebug) {
            System.out.println("  Date: " + this.date);
        }
        this.subject = r2.readString();
        if (parseDebug) {
            System.out.println("  Subject: " + this.subject);
        }
        if (parseDebug) {
            System.out.println("  From addresses:");
        }
        this.from = this.parseAddressList(r2);
        if (parseDebug) {
            System.out.println("  Sender addresses:");
        }
        this.sender = this.parseAddressList(r2);
        if (parseDebug) {
            System.out.println("  Reply-To addresses:");
        }
        this.replyTo = this.parseAddressList(r2);
        if (parseDebug) {
            System.out.println("  To addresses:");
        }
        this.to = this.parseAddressList(r2);
        if (parseDebug) {
            System.out.println("  Cc addresses:");
        }
        this.cc = this.parseAddressList(r2);
        if (parseDebug) {
            System.out.println("  Bcc addresses:");
        }
        this.bcc = this.parseAddressList(r2);
        this.inReplyTo = r2.readString();
        if (parseDebug) {
            System.out.println("  In-Reply-To: " + this.inReplyTo);
        }
        this.messageId = r2.readString();
        if (parseDebug) {
            System.out.println("  Message-ID: " + this.messageId);
        }
        if (!r2.isNextNonSpace(')')) {
            throw new ParsingException("ENVELOPE parse error");
        }
    }

    private InternetAddress[] parseAddressList(Response r2) throws ParsingException {
        r2.skipSpaces();
        byte b2 = r2.readByte();
        if (b2 == 40) {
            if (r2.isNextNonSpace(')')) {
                return null;
            }
            ArrayList<IMAPAddress> v2 = new ArrayList<IMAPAddress>();
            do {
                IMAPAddress a2 = new IMAPAddress(r2);
                if (parseDebug) {
                    System.out.println("    Address: " + a2);
                }
                if (a2.isEndOfGroup()) continue;
                v2.add(a2);
            } while (!r2.isNextNonSpace(')'));
            return v2.toArray(new InternetAddress[v2.size()]);
        }
        if (b2 == 78 || b2 == 110) {
            r2.skip(2);
            return null;
        }
        throw new ParsingException("ADDRESS parse error");
    }
}

