/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.parser;

import com.sun.el.lang.ELSupport;
import com.sun.el.lang.EvaluationContext;
import com.sun.el.parser.ELParserTreeConstants;
import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import com.sun.el.util.MessageFactory;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.PropertyNotWritableException;
import javax.el.ValueReference;

public abstract class SimpleNode
extends ELSupport
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected String image;

    public SimpleNode(int i2) {
        this.id = i2;
    }

    @Override
    public void jjtOpen() {
    }

    @Override
    public void jjtClose() {
    }

    @Override
    public void jjtSetParent(Node n2) {
        this.parent = n2;
    }

    @Override
    public Node jjtGetParent() {
        return this.parent;
    }

    @Override
    public void jjtAddChild(Node n2, int i2) {
        if (this.children == null) {
            this.children = new Node[i2 + 1];
        } else if (i2 >= this.children.length) {
            Node[] c2 = new Node[i2 + 1];
            System.arraycopy(this.children, 0, c2, 0, this.children.length);
            this.children = c2;
        }
        this.children[i2] = n2;
    }

    @Override
    public Node jjtGetChild(int i2) {
        return this.children[i2];
    }

    @Override
    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public String toString() {
        if (this.image != null) {
            return ELParserTreeConstants.jjtNodeName[this.id] + "[" + this.image + "]";
        }
        return ELParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                SimpleNode n2 = (SimpleNode)this.children[i2];
                if (n2 == null) continue;
                n2.dump(prefix + " ");
            }
        }
    }

    @Override
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @Override
    public Class getType(EvaluationContext ctx) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) throws ELException {
        return null;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        return true;
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        throw new PropertyNotWritableException(MessageFactory.get("error.syntax.set"));
    }

    @Override
    public void accept(NodeVisitor visitor) throws ELException {
        visitor.visit(this);
        if (this.children != null && this.children.length > 0) {
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                this.children[i2].accept(visitor);
            }
        }
    }

    @Override
    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object node) {
        if (!(node instanceof SimpleNode)) {
            return false;
        }
        SimpleNode n2 = (SimpleNode)node;
        if (this.id != n2.id) {
            return false;
        }
        if (this.children == null && n2.children == null) {
            if (this.image == null) {
                return n2.image == null;
            }
            return this.image.equals(n2.image);
        }
        if (this.children == null || n2.children == null) {
            return false;
        }
        if (this.children.length != n2.children.length) {
            return false;
        }
        if (this.children.length == 0) {
            if (this.image == null) {
                return n2.image == null;
            }
            return this.image.equals(n2.image);
        }
        for (int i2 = 0; i2 < this.children.length; ++i2) {
            if (this.children[i2].equals(n2.children[i2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isParametersProvided() {
        return false;
    }

    @Override
    public int hashCode() {
        if (this.children == null || this.children.length == 0) {
            if (this.image != null) {
                return this.image.hashCode();
            }
            return this.id;
        }
        int h2 = 0;
        for (int i2 = this.children.length - 1; i2 >= 0; --i2) {
            h2 = h2 + h2 + h2 + this.children[i2].hashCode();
        }
        h2 = h2 + h2 + h2 + this.id;
        return h2;
    }
}

